/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class ExternalSystemSockJsEndpoint implements net.bluemind.system.api.IExternalSystemAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public ExternalSystemSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/system/external";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public ExternalSystemSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getExternalSystem(String systemIdentifier, final AsyncHandler<net.bluemind.system.api.ExternalSystem> handler) {
		String postUri = "/{systemIdentifier}";

		postUri = postUri.replace("{systemIdentifier}", URL.encodePathSegment(""+systemIdentifier));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.system.api.ExternalSystem>(handler) {
					@Override
			protected net.bluemind.system.api.ExternalSystem handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.system.api.gwt.serder.ExternalSystemGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getExternalSystems(final AsyncHandler<List<net.bluemind.system.api.ExternalSystem>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.system.api.ExternalSystem>>(handler) {
					@Override
			protected List<net.bluemind.system.api.ExternalSystem> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.ExternalSystemGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getExternalSystemsByAuthKind(Set<net.bluemind.system.api.ExternalSystem.AuthKind> authKinds, final AsyncHandler<List<net.bluemind.system.api.ExternalSystem>> handler) {
		String postUri = "/_by_authkind";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.SetSerDer<>(new net.bluemind.system.api.gwt.serder.ExternalSystemAuthKindGwtSerDer()).serialize( authKinds);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.system.api.ExternalSystem>>(handler) {
					@Override
			protected List<net.bluemind.system.api.ExternalSystem> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.system.api.gwt.serder.ExternalSystemGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getLogo(String systemIdentifier, final AsyncHandler<byte[]> handler) {
		String postUri = "/{systemIdentifier}/_logo";

		postUri = postUri.replace("{systemIdentifier}", URL.encodePathSegment(""+systemIdentifier));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<byte[]>(handler) {
					@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void testConnection(String systemIdentifier, net.bluemind.user.api.UserAccount account, final AsyncHandler<net.bluemind.system.api.ConnectionTestStatus> handler) {
		String postUri = "/{systemIdentifier}/_test_connection";

		postUri = postUri.replace("{systemIdentifier}", URL.encodePathSegment(""+systemIdentifier));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.user.api.gwt.serder.UserAccountGwtSerDer().serialize( account);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.system.api.ConnectionTestStatus>(handler) {
					@Override
			protected net.bluemind.system.api.ConnectionTestStatus handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.system.api.gwt.serder.ConnectionTestStatusGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.system.api.IExternalSystemPromise promiseApi() {
		return new ExternalSystemEndpointPromise(this);
	}

}
