/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.addressbook.adapter;

import java.util.Arrays;
import java.util.Collections;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.authentication.api.IAuthentication;
import net.bluemind.config.Token;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.serviceprovider.SPResolver;
import net.bluemind.user.api.IUser;
import net.bluemind.user.api.User;

public final class Sudo implements AutoCloseable {
	private static final Logger logger = LoggerFactory.getLogger(Sudo.class);

	private final ItemValue<User> user;
	public final SecurityContext context;

	public Sudo(String uid, String domainContainerUid) throws ServerFault {
		IServiceProvider iServiceProvider = SPResolver.get().resolve(Token.admin0());
		IUser u = iServiceProvider.instance(IUser.class, domainContainerUid);
		ItemValue<User> theUser = u.getComplete(uid);
		if (theUser == null) {
			throw ServerFault.notFound("UID for " + uid + " in " + domainContainerUid + " not found.");
		}
		this.user = theUser;
		logger.debug("[{}] sudo login {} has uid {}", domainContainerUid, uid, theUser.uid);
		String authKey = iServiceProvider.instance(IAuthentication.class)
				.su(user.value.login + "@" + domainContainerUid).authKey;
		SecurityContext userContext = new SecurityContext(authKey, user.uid, Arrays.<String>asList(),
				Arrays.<String>asList(), Collections.emptyMap(), domainContainerUid, "en", "Sudo", false);
		this.context = userContext;
	}

	public IServiceProvider provider() {
		return SPResolver.get().resolve(context.getSessionId());
	}

	@Override
	public void close() {
		provider().instance(IAuthentication.class).logout();
	}

}
