package net.bluemind.directory.hollow.datamodel.consumer.multicore.keydb;

import java.util.function.Supplier;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import net.bluemind.directory.hollow.datamodel.AddressBookRecord;
import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;
import net.bluemind.directory.hollow.datamodel.OfflineAddressBook;
import net.bluemind.keydb.common.ClientProvider;
import net.bluemind.keydb.common.ObjectCodec;

public class RedisConnections {

	private static RedisConnections instance = null;
	private static final Object lock = new Object();

	public static final Supplier<RedisConnections> factory = () -> {
		synchronized (lock) {
			if (instance == null) {
				instance = new RedisConnections();
			}
		}
		return instance;
	};

	private RedisPubSubCommands<String, String> versionPubsubCommand;
	private StatefulRedisPubSubConnection<String, String> versionPubsubConnection;
	private RedisCommands<String, String> versionCommand;
	private RedisCommands<String, OfflineAddressBook> offlineRecordCommand;
	private RedisCommands<String, AddressBookRecordIndexOnly> indexCommand;
	private RedisAsyncCommands<String, AddressBookRecord> asyncRecordCommand;
	private RedisCommands<String, AddressBookRecord> recordCommand;

	private RedisConnections() {
		RedisClient redisClient = ClientProvider.newClient();

		StatefulRedisConnection<String, AddressBookRecord> recordConnection = redisClient
				.connect(new ObjectCodec<>(AddressBookRecord.class));
		recordCommand = recordConnection.sync();
		asyncRecordCommand = recordConnection.async();

		versionPubsubConnection = redisClient.connectPubSub();
		versionPubsubCommand = versionPubsubConnection.sync();
		versionCommand = ClientProvider.newClient().connect().sync();
		indexCommand = redisClient.connect(new ObjectCodec<>(AddressBookRecordIndexOnly.class)).sync();

		StatefulRedisConnection<String, OfflineAddressBook> offlineAddressBookConnection = redisClient
				.connect(new ObjectCodec<>(OfflineAddressBook.class));
		offlineRecordCommand = offlineAddressBookConnection.sync();
	}

	public RedisPubSubCommands<String, String> getVersionPubsubCommand() {
		return versionPubsubCommand;
	}

	public StatefulRedisPubSubConnection<String, String> getVersionPubsubConnection() {
		return versionPubsubConnection;
	}

	public RedisCommands<String, String> getVersionCommand() {
		return versionCommand;
	}

	public RedisCommands<String, OfflineAddressBook> getOfflineRecordCommand() {
		return offlineRecordCommand;
	}

	public RedisCommands<String, AddressBookRecordIndexOnly> getIndexCommand() {
		return indexCommand;
	}

	public RedisAsyncCommands<String, AddressBookRecord> getAsyncRecordCommand() {
		return asyncRecordCommand;
	}

	public RedisCommands<String, AddressBookRecord> getRecordCommand() {
		return recordCommand;
	}

}
