/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.directory.ou.event;

import com.google.gwt.event.shared.GwtEvent;

public class OUResourcesEvent extends GwtEvent<OUResourcesEventHandler> {

	public static Type<OUResourcesEventHandler> TYPE = new Type<>();

	public boolean selectedItems;

	public OUResourcesEvent(boolean selectedItems) {
		this.selectedItems = selectedItems;
	}

	@Override
	public Type<OUResourcesEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(OUResourcesEventHandler handler) {
		handler.onOuResourcesLoad(this);
	}
}
