/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class FolderSyncVersionsGwtSerDer implements GwtSerDer<net.bluemind.eas.api.FolderSyncVersions> {

	public FolderSyncVersionsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.eas.api.FolderSyncVersions deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.eas.api.FolderSyncVersions ret = new net.bluemind.eas.api.FolderSyncVersions();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.eas.api.FolderSyncVersions ret, JSONObject json) {
		JSONValue accountJSON = json.get("account");
		ret.account =  new net.bluemind.eas.api.gwt.serder.AccountGwtSerDer().deserialize(accountJSON);
		JSONValue versionsJSON = json.get("versions");
		ret.versions =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(versionsJSON);
	}

	public void deserializeTo(net.bluemind.eas.api.FolderSyncVersions ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("account")) {
			JSONValue accountJSON = json.get("account");
			ret.account =  new net.bluemind.eas.api.gwt.serder.AccountGwtSerDer().deserialize(accountJSON);
		}
		if (!childPropertiesToIgnore.contains("versions")) {
			JSONValue versionsJSON = json.get("versions");
			ret.versions =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(versionsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.eas.api.FolderSyncVersions o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.eas.api.FolderSyncVersions o, JSONObject ret) {

		ret.put("account",  new net.bluemind.eas.api.gwt.serder.AccountGwtSerDer().serialize( o.account ));
		ret.put("versions",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.versions ));
	}

	public void serializeTo(net.bluemind.eas.api.FolderSyncVersions o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("account")) {
			ret.put("account",  new net.bluemind.eas.api.gwt.serder.AccountGwtSerDer().serialize( o.account ));
		}
		if (!childPropertiesToIgnore.contains("versions")) {
			ret.put("versions",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.versions ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}