/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AccountGwtSerDer implements GwtSerDer<net.bluemind.eas.api.Account> {

	public AccountGwtSerDer( ) {
	}

	@Override
	public net.bluemind.eas.api.Account deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.eas.api.Account ret = new net.bluemind.eas.api.Account();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.eas.api.Account ret, JSONObject json) {
		JSONValue userUidJSON = json.get("userUid");
		ret.userUid =  GwtSerDerUtils.STRING.deserialize(userUidJSON);
		JSONValue deviceJSON = json.get("device");
		ret.device =  GwtSerDerUtils.STRING.deserialize(deviceJSON);
	}

	public void deserializeTo(net.bluemind.eas.api.Account ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("userUid")) {
			JSONValue userUidJSON = json.get("userUid");
			ret.userUid =  GwtSerDerUtils.STRING.deserialize(userUidJSON);
		}
		if (!childPropertiesToIgnore.contains("device")) {
			JSONValue deviceJSON = json.get("device");
			ret.device =  GwtSerDerUtils.STRING.deserialize(deviceJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.eas.api.Account o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.eas.api.Account o, JSONObject ret) {

		ret.put("userUid",  GwtSerDerUtils.STRING.serialize( o.userUid ));
		ret.put("device",  GwtSerDerUtils.STRING.serialize( o.device ));
	}

	public void serializeTo(net.bluemind.eas.api.Account o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("userUid")) {
			ret.put("userUid",  GwtSerDerUtils.STRING.serialize( o.userUid ));
		}
		if (!childPropertiesToIgnore.contains("device")) {
			ret.put("device",  GwtSerDerUtils.STRING.serialize( o.device ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}