/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ItemDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ItemDescriptor> {

	public ItemDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ItemDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ItemDescriptor ret = new net.bluemind.core.container.model.ItemDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemDescriptor ret, JSONObject json) {
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue externalIdJSON = json.get("externalId");
		ret.externalId =  GwtSerDerUtils.STRING.deserialize(externalIdJSON);
		JSONValue internalIdJSON = json.get("internalId");
		ret.internalId =  GwtSerDerUtils.LONG.deserialize(internalIdJSON);
		JSONValue createdByJSON = json.get("createdBy");
		ret.createdBy =  GwtSerDerUtils.STRING.deserialize(createdByJSON);
		JSONValue updatedByJSON = json.get("updatedBy");
		ret.updatedBy =  GwtSerDerUtils.STRING.deserialize(updatedByJSON);
		JSONValue createdJSON = json.get("created");
		ret.created =  GwtSerDerUtils.DATE.deserialize(createdJSON);
		JSONValue updatedJSON = json.get("updated");
		ret.updated =  GwtSerDerUtils.DATE.deserialize(updatedJSON);
		JSONValue flagsJSON = json.get("flags");
		ret.flags =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).deserialize(flagsJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("version")) {
			JSONValue versionJSON = json.get("version");
			ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		}
		if (!childPropertiesToIgnore.contains("displayName")) {
			JSONValue displayNameJSON = json.get("displayName");
			ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		}
		if (!childPropertiesToIgnore.contains("externalId")) {
			JSONValue externalIdJSON = json.get("externalId");
			ret.externalId =  GwtSerDerUtils.STRING.deserialize(externalIdJSON);
		}
		if (!childPropertiesToIgnore.contains("internalId")) {
			JSONValue internalIdJSON = json.get("internalId");
			ret.internalId =  GwtSerDerUtils.LONG.deserialize(internalIdJSON);
		}
		if (!childPropertiesToIgnore.contains("createdBy")) {
			JSONValue createdByJSON = json.get("createdBy");
			ret.createdBy =  GwtSerDerUtils.STRING.deserialize(createdByJSON);
		}
		if (!childPropertiesToIgnore.contains("updatedBy")) {
			JSONValue updatedByJSON = json.get("updatedBy");
			ret.updatedBy =  GwtSerDerUtils.STRING.deserialize(updatedByJSON);
		}
		if (!childPropertiesToIgnore.contains("created")) {
			JSONValue createdJSON = json.get("created");
			ret.created =  GwtSerDerUtils.DATE.deserialize(createdJSON);
		}
		if (!childPropertiesToIgnore.contains("updated")) {
			JSONValue updatedJSON = json.get("updated");
			ret.updated =  GwtSerDerUtils.DATE.deserialize(updatedJSON);
		}
		if (!childPropertiesToIgnore.contains("flags")) {
			JSONValue flagsJSON = json.get("flags");
			ret.flags =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).deserialize(flagsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ItemDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ItemDescriptor o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("externalId",  GwtSerDerUtils.STRING.serialize( o.externalId ));
		ret.put("internalId",  GwtSerDerUtils.LONG.serialize( o.internalId ));
		ret.put("createdBy",  GwtSerDerUtils.STRING.serialize( o.createdBy ));
		ret.put("updatedBy",  GwtSerDerUtils.STRING.serialize( o.updatedBy ));
		ret.put("created",  GwtSerDerUtils.DATE.serialize( o.created ));
		ret.put("updated",  GwtSerDerUtils.DATE.serialize( o.updated ));
		ret.put("flags",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).serialize( o.flags ));
	}

	public void serializeTo(net.bluemind.core.container.model.ItemDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("version")) {
			ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		}
		if (!childPropertiesToIgnore.contains("displayName")) {
			ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		}
		if (!childPropertiesToIgnore.contains("externalId")) {
			ret.put("externalId",  GwtSerDerUtils.STRING.serialize( o.externalId ));
		}
		if (!childPropertiesToIgnore.contains("internalId")) {
			ret.put("internalId",  GwtSerDerUtils.LONG.serialize( o.internalId ));
		}
		if (!childPropertiesToIgnore.contains("createdBy")) {
			ret.put("createdBy",  GwtSerDerUtils.STRING.serialize( o.createdBy ));
		}
		if (!childPropertiesToIgnore.contains("updatedBy")) {
			ret.put("updatedBy",  GwtSerDerUtils.STRING.serialize( o.updatedBy ));
		}
		if (!childPropertiesToIgnore.contains("created")) {
			ret.put("created",  GwtSerDerUtils.DATE.serialize( o.created ));
		}
		if (!childPropertiesToIgnore.contains("updated")) {
			ret.put("updated",  GwtSerDerUtils.DATE.serialize( o.updated ));
		}
		if (!childPropertiesToIgnore.contains("flags")) {
			ret.put("flags",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).serialize( o.flags ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}