/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class BaseContainerDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.BaseContainerDescriptor> {

	public BaseContainerDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.BaseContainerDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.BaseContainerDescriptor ret = new net.bluemind.core.container.model.BaseContainerDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.BaseContainerDescriptor ret, JSONObject json) {
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		JSONValue defaultContainerJSON = json.get("defaultContainer");
		ret.defaultContainer =  GwtSerDerUtils.BOOLEAN.deserialize(defaultContainerJSON);
		JSONValue readOnlyJSON = json.get("readOnly");
		ret.readOnly =  GwtSerDerUtils.BOOLEAN.deserialize(readOnlyJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue ownerDisplaynameJSON = json.get("ownerDisplayname");
		ret.ownerDisplayname =  GwtSerDerUtils.STRING.deserialize(ownerDisplaynameJSON);
		JSONValue ownerDirEntryPathJSON = json.get("ownerDirEntryPath");
		ret.ownerDirEntryPath =  GwtSerDerUtils.STRING.deserialize(ownerDirEntryPathJSON);
		JSONValue settingsJSON = json.get("settings");
		ret.settings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(settingsJSON);
		JSONValue deletedJSON = json.get("deleted");
		ret.deleted =  GwtSerDerUtils.BOOLEAN.deserialize(deletedJSON);
		JSONValue datalocationJSON = json.get("datalocation");
		ret.datalocation =  GwtSerDerUtils.STRING.deserialize(datalocationJSON);
		JSONValue internalIdJSON = json.get("internalId");
		ret.internalId =  GwtSerDerUtils.LONG.deserialize(internalIdJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.BaseContainerDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("defaultContainer")) {
			JSONValue defaultContainerJSON = json.get("defaultContainer");
			ret.defaultContainer =  GwtSerDerUtils.BOOLEAN.deserialize(defaultContainerJSON);
		}
		if (!childPropertiesToIgnore.contains("readOnly")) {
			JSONValue readOnlyJSON = json.get("readOnly");
			ret.readOnly =  GwtSerDerUtils.BOOLEAN.deserialize(readOnlyJSON);
		}
		if (!childPropertiesToIgnore.contains("domainUid")) {
			JSONValue domainUidJSON = json.get("domainUid");
			ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		}
		if (!childPropertiesToIgnore.contains("ownerDisplayname")) {
			JSONValue ownerDisplaynameJSON = json.get("ownerDisplayname");
			ret.ownerDisplayname =  GwtSerDerUtils.STRING.deserialize(ownerDisplaynameJSON);
		}
		if (!childPropertiesToIgnore.contains("ownerDirEntryPath")) {
			JSONValue ownerDirEntryPathJSON = json.get("ownerDirEntryPath");
			ret.ownerDirEntryPath =  GwtSerDerUtils.STRING.deserialize(ownerDirEntryPathJSON);
		}
		if (!childPropertiesToIgnore.contains("settings")) {
			JSONValue settingsJSON = json.get("settings");
			ret.settings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(settingsJSON);
		}
		if (!childPropertiesToIgnore.contains("deleted")) {
			JSONValue deletedJSON = json.get("deleted");
			ret.deleted =  GwtSerDerUtils.BOOLEAN.deserialize(deletedJSON);
		}
		if (!childPropertiesToIgnore.contains("datalocation")) {
			JSONValue datalocationJSON = json.get("datalocation");
			ret.datalocation =  GwtSerDerUtils.STRING.deserialize(datalocationJSON);
		}
		if (!childPropertiesToIgnore.contains("internalId")) {
			JSONValue internalIdJSON = json.get("internalId");
			ret.internalId =  GwtSerDerUtils.LONG.deserialize(internalIdJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.BaseContainerDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.BaseContainerDescriptor o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		ret.put("defaultContainer",  GwtSerDerUtils.BOOLEAN.serialize( o.defaultContainer ));
		ret.put("readOnly",  GwtSerDerUtils.BOOLEAN.serialize( o.readOnly ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("ownerDisplayname",  GwtSerDerUtils.STRING.serialize( o.ownerDisplayname ));
		ret.put("ownerDirEntryPath",  GwtSerDerUtils.STRING.serialize( o.ownerDirEntryPath ));
		ret.put("settings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.settings ));
		ret.put("deleted",  GwtSerDerUtils.BOOLEAN.serialize( o.deleted ));
		ret.put("datalocation",  GwtSerDerUtils.STRING.serialize( o.datalocation ));
		ret.put("internalId",  GwtSerDerUtils.LONG.serialize( o.internalId ));
	}

	public void serializeTo(net.bluemind.core.container.model.BaseContainerDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("defaultContainer")) {
			ret.put("defaultContainer",  GwtSerDerUtils.BOOLEAN.serialize( o.defaultContainer ));
		}
		if (!childPropertiesToIgnore.contains("readOnly")) {
			ret.put("readOnly",  GwtSerDerUtils.BOOLEAN.serialize( o.readOnly ));
		}
		if (!childPropertiesToIgnore.contains("domainUid")) {
			ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		}
		if (!childPropertiesToIgnore.contains("ownerDisplayname")) {
			ret.put("ownerDisplayname",  GwtSerDerUtils.STRING.serialize( o.ownerDisplayname ));
		}
		if (!childPropertiesToIgnore.contains("ownerDirEntryPath")) {
			ret.put("ownerDirEntryPath",  GwtSerDerUtils.STRING.serialize( o.ownerDirEntryPath ));
		}
		if (!childPropertiesToIgnore.contains("settings")) {
			ret.put("settings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.settings ));
		}
		if (!childPropertiesToIgnore.contains("deleted")) {
			ret.put("deleted",  GwtSerDerUtils.BOOLEAN.serialize( o.deleted ));
		}
		if (!childPropertiesToIgnore.contains("datalocation")) {
			ret.put("datalocation",  GwtSerDerUtils.STRING.serialize( o.datalocation ));
		}
		if (!childPropertiesToIgnore.contains("internalId")) {
			ret.put("internalId",  GwtSerDerUtils.LONG.serialize( o.internalId ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}