/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2024
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
*/
package net.bluemind.keydb.sessions;

import net.bluemind.keydb.sessiondata.SessionDataStore;
import net.bluemind.keydb.sessions.codec.SecurityContextCodec;

public class SessionsHelper {

	// To keep the value after expire
	// https://stackoverflow.com/questions/18328058/redis-notifications-get-key-and-value-on-expiration
	public static final String CORE_VALUE_HOLDER = "core:sid:v" + SecurityContextCodec.CODEC_VERSION + ":";
	public static final String CORE_EXPIRATION_KEY = "core:shadow:sid:";

	private SessionsHelper() {
	}

	public static String expirationKey(String sid) {
		return CORE_EXPIRATION_KEY + sid;
	}

	public static String sidFromExpirationKey(String key) {
		return key.replace(CORE_EXPIRATION_KEY, "");
	}

	public static String valueHolder(String sid) {
		return CORE_VALUE_HOLDER + sid;
	}

	public static String sidFromValueHolder(String key) {
		return key.replace(CORE_VALUE_HOLDER, "");
	}

	public static String dataHolder(String sid) {
		return SessionDataStore.DATA_VALUE_HOLDER + sid;
	}

	public static String sidFromDataHolder(String key) {
		return key.replace(SessionDataStore.DATA_VALUE_HOLDER, "");
	}
}