<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * PrintOptions.
 */
class PrintOptions  {

  /*
   * @type PrintOptionsPrintView
   */
  public $view;

  /*
   * @type PrintOptionsPrintFormat
   */
  public $format;

  /*
   * @type BmDateTime
   */
  public $dateBegin;

  /*
   * @type BmDateTime
   */
  public $dateEnd;

  /*
   * @type boolean
   */
  public $color;

  /*
   * @type boolean
   */
  public $showDetail;

  /*
   * @type boolean
   */
  public $showCancelled;

  /*
   * @type PrintOptionsPrintLayout
   */
  public $layout;

  /*
   * @type List
   */
  public $calendars;

  /*
   * @type Set
   */
  public $tagsFilter;

  /*
   * Constructor
   */
  public function __construct() {
    $this->dateBegin = null;
    $this->dateEnd = null;
    $this->color = false;
    $this->showDetail = false;
    $this->showCancelled = false;
    $this->calendars =  array();
    $this->tagsFilter = array();
  }

  public function toMap() {
    $data = array(    
        "view" => empty($this->view) ? null : $this->view,    
        "format" => empty($this->format) ? null : $this->format,    
        "dateBegin" => empty($this->dateBegin) ? null : $this->dateBegin,    
        "dateEnd" => empty($this->dateEnd) ? null : $this->dateEnd,    
        "color" => empty($this->color) ? null : $this->color,    
        "showDetail" => empty($this->showDetail) ? null : $this->showDetail,    
        "showCancelled" => empty($this->showCancelled) ? null : $this->showCancelled,    
        "layout" => empty($this->layout) ? null : $this->layout,    
        "calendars" => empty($this->calendars) ? null : $this->calendars,    
        "tagsFilter" => empty($this->tagsFilter) ? null : $this->tagsFilter);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
