/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.imap.command;

import java.util.List;

import net.bluemind.imap.impl.IMAPResponse;

/**
 * Removes an ACL on a mailbox
 * 
 * Should be used like : <code>dam user/admin@willow.vmw admin0</code>
 * 
 * 
 */
public class DeleteAclCommand extends SimpleCommand<Boolean> {

	/**
	 * @param mailboxName
	 *            user/admin@willow.vmw
	 * @param ownerId
	 *            admin0
	 */
	public DeleteAclCommand(String mailboxName, String ownerId) {
		super("DELETEACL " + toUtf7(mailboxName) + " " + ownerId);
	}

	@Override
	public void responseReceived(List<IMAPResponse> rs) {
		IMAPResponse last = rs.get(rs.size() - 1);
		data = last.isOk();
	}
}
