/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.todolist;

import net.bluemind.core.container.model.ContainerDescriptor;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.common.restore.directory.RestoreDirWorker;
import net.bluemind.todolist.api.ITodoListsMgmt;

public class RestoreTodolistsWorker extends RestoreDirWorker<ContainerDescriptor> {

	public RestoreTodolistsWorker(DataProtectGeneration backup, IMonitoredRestoreRestorableItem restorableItem) {
		super(backup, restorableItem);
	}

	@Override
	public ItemValue<ContainerDescriptor> createOrUpdateLiveEntry(ItemValue<ContainerDescriptor> backupTodo)
			throws InterruptedException {

		BmContext live = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM).getContext();
		ITodoListsMgmt serviceLive = live.provider().instance(ITodoListsMgmt.class);

		ContainerDescriptor liveEntry = serviceLive.getComplete(backupTodo.uid);
		if (liveEntry != null) {
			serviceLive.update(backupTodo.uid, backupTodo.value);
			return ItemValue.create(backupTodo.uid, liveEntry);
		}

		serviceLive.create(backupTodo.uid, backupTodo.value, false);
		liveEntry = serviceLive.getComplete(backupTodo.uid);
		return ItemValue.create(backupTodo.uid, liveEntry);
	}

	@Override
	public void restoreEntryDependantContainers() {
	}
}
