/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dav.server.proto.props.calendarserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

import net.bluemind.core.container.api.ContainerSubscriptionDescriptor;
import net.bluemind.dav.server.proto.IPropertyValue;
import net.bluemind.dav.server.proto.NS;
import net.bluemind.dav.server.proto.props.IPropertyFactory;
import net.bluemind.dav.server.store.DavResource;
import net.bluemind.dav.server.store.LoggedCore;

public class CalendarProxyReadFor extends CalendarProxyXXFor {
	public static final QName NAME = new QName(NS.CSRV_ORG, "calendar-proxy-read-for");

	private static final Logger logger = LoggerFactory.getLogger(CalendarProxyReadFor.class);

	@Override
	public QName getName() {
		return NAME;
	}

	public static IPropertyFactory factory() {
		return new IPropertyFactory() {
			@Override
			public IPropertyValue create() {
				return new CalendarProxyReadFor();
			}
		};
	}

	protected List<ContainerSubscriptionDescriptor> filterSubscriptionsByOwner(String owner,
			List<ContainerSubscriptionDescriptor> cis) {
		Map<String, ContainerSubscriptionDescriptor> filter = new HashMap<>(cis.size());
		for (ContainerSubscriptionDescriptor ci : cis) {
			if (!ci.owner.equals(owner)) {
				filter.put(ci.owner, ci);
			}
		}
		return new ArrayList<ContainerSubscriptionDescriptor>(filter.values());
	}

	@Override
	public void set(LoggedCore lc, DavResource dr, Element value) throws Exception {
		logger.info("[{}] set on {}", dr.getResType(), dr.getPath());
	}

}
