/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.task.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsTaskStatusState extends JavaScriptObject {

	protected JsTaskStatusState() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsTaskStatusState NotStarted()
	/*-{
		return "NotStarted";
	}-*/;

	public static final native JsTaskStatusState InProgress()
	/*-{
		return "InProgress";
	}-*/;

	public static final native JsTaskStatusState InError()
	/*-{
		return "InError";
	}-*/;

	public static final native JsTaskStatusState Success()
	/*-{
		return "Success";
	}-*/;

	public static final JsTaskStatusState create(net.bluemind.core.task.api.TaskStatus.State value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NotStarted:
				return NotStarted();
			case InProgress:
				return InProgress();
			case InError:
				return InError();
			case Success:
				return Success();
			default:
				return null;
			}
		}
	}
}