/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2021
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.backup.continuous.restore.orphans;

import java.util.List;

import com.fasterxml.jackson.core.type.TypeReference;

import net.bluemind.core.backup.continuous.DataElement;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.dataprotect.api.IDataProtect;
import net.bluemind.dataprotect.api.RetentionPolicy;

public class RestoreDpRetention {

	private final IServiceProvider target;

	public RestoreDpRetention(IServiceProvider target) {
		this.target = target;
	}

	public void restore(IServerTaskMonitor monitor, List<DataElement> rp) {
		if (rp.isEmpty()) {
			return;
		}
		DataElement last = rp.get(rp.size() - 1);
		ValueReader<ItemValue<RetentionPolicy>> scReader = JsonUtils
				.reader(new TypeReference<ItemValue<RetentionPolicy>>() {
				});
		RetentionPolicy sysconf = scReader.read(new String(last.payload)).value;
		if (sysconf != null) {
			IDataProtect dpApi = target.instance(IDataProtect.class);
			dpApi.updatePolicy(sysconf);
		}
		monitor.progress(1, "Retention policy restored");
	}
}
