/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api;

import java.util.List;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import net.bluemind.core.api.BMApi;
import net.bluemind.core.api.fault.ServerFault;

@BMApi(version = "3", internal = true)
@Path("/credentials/{domainUid}")
public interface IInternalCredentials extends ICredentials {
	/**
	 * Get credentials from its ID
	 *
	 * @param credentialFullId use <i>domainUid:credentialId</i> syntax, where :
	 *                         <ul>
	 *                         <li><i>domainUid</i> is credential domain UID for
	 *                         domain related credentials, or global.virt</li>
	 *                         <li><i>id</i> is the credential ID</li>
	 *                         </ul>
	 * @return credential value or null if not exists or not found
	 * @throws ServerFault
	 */
	@GET
	@Path("{credentialId}")
	public String getDomainCredentialById(@PathParam(value = "credentialId") String credentialId);

	/**
	 * Add user credential<br/>
	 *
	 * Used by bm-keycloak to store credentials
	 *
	 * @param userUid
	 * @param credential
	 */
	@PUT
	@Path("user/{userUid}")
	public void addUserCredential(@PathParam(value = "userUid") String userUid, Credential credential);

	public void restoreUserCredential(@PathParam(value = "userUid") String userUid, Credential credential);

	public void deleteUserCredential(@PathParam(value = "userUid") String userUid, String credentialId);

	@PUT
	@Path("user/{userUid}/_credentials")
	public void addUserCredentials(@PathParam(value = "userUid") String userUid, List<Credential> credentials);

	/**
	 * Get user credentials with secret</br>
	 *
	 * Used by bm-keycloak to store credentials
	 *
	 * @param userUid
	 * @return
	 */
	@GET
	@Path("user/{userUid}/plain")
	public List<Credential> getUserCredentials(@PathParam(value = "userUid") String userUid);
}
