/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsGenerationStatus extends JavaScriptObject {

	protected JsGenerationStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsGenerationStatus VALID()
	/*-{
		return "VALID";
	}-*/;

	public static final native JsGenerationStatus INVALID()
	/*-{
		return "INVALID";
	}-*/;

	public static final native JsGenerationStatus UNKNOWN()
	/*-{
		return "UNKNOWN";
	}-*/;

	public static final JsGenerationStatus create(net.bluemind.dataprotect.api.GenerationStatus value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case VALID:
				return VALID();
			case INVALID:
				return INVALID();
			case UNKNOWN:
				return UNKNOWN();
			default:
				return null;
			}
		}
	}
}