/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsDataProtectGeneration extends JavaScriptObject {

	protected JsDataProtectGeneration() {}

	public final native int getId()
	/*-{
	return this["id"];
	}-*/;

	public final native void setId(int id)
	/*-{
       this["id"] = id;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getProtectionTime()
	/*-{
       if(this["protectionTime"]) {
          return new Date(this["protectionTime"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setProtectionTime(com.google.gwt.core.client.JsDate protectionTime)
	/*-{
       this["protectionTime"] =  ( protectionTime != null) ? protectionTime.getTime() : null;
	}-*/;

	public final native net.bluemind.core.api.gwt.js.JsVersionInfo getBlueMind()
	/*-{
	return this["blueMind"];
	}-*/;

	public final native void setBlueMind(net.bluemind.core.api.gwt.js.JsVersionInfo blueMind)
	/*-{
       this["blueMind"] = blueMind;
	}-*/;

	public final native boolean getWithWarnings()
	/*-{
	return this["withWarnings"];
	}-*/;

	public final native void setWithWarnings(boolean withWarnings)
	/*-{
       this["withWarnings"] = withWarnings;
	}-*/;

	public final native boolean getWithErrors()
	/*-{
	return this["withErrors"];
	}-*/;

	public final native void setWithErrors(boolean withErrors)
	/*-{
       this["withErrors"] = withErrors;
	}-*/;

	public final native com.google.gwt.core.client.JsArray<net.bluemind.dataprotect.api.gwt.js.JsPartGeneration> getParts()
	/*-{
	return this["parts"];
	}-*/;

	public final native void setParts(com.google.gwt.core.client.JsArray<net.bluemind.dataprotect.api.gwt.js.JsPartGeneration> parts)
	/*-{
       this["parts"] = parts;
	}-*/;

	public static native  JsDataProtectGeneration create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}