/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.smime.cacerts.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SmimeRevocationGwtSerDer implements GwtSerDer<net.bluemind.smime.cacerts.api.SmimeRevocation> {

	private net.bluemind.smime.cacerts.api.gwt.serder.SmimeCertClientGwtSerDer parent = new  net.bluemind.smime.cacerts.api.gwt.serder.SmimeCertClientGwtSerDer();
	public SmimeRevocationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.smime.cacerts.api.SmimeRevocation deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.smime.cacerts.api.SmimeRevocation ret = new net.bluemind.smime.cacerts.api.SmimeRevocation();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.SmimeRevocation ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue revocationDateJSON = json.get("revocationDate");
		ret.revocationDate =  GwtSerDerUtils.DATE.deserialize(revocationDateJSON);
		JSONValue revocationReasonJSON = json.get("revocationReason");
		ret.revocationReason =  GwtSerDerUtils.STRING.deserialize(revocationReasonJSON);
		JSONValue urlJSON = json.get("url");
		ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
		JSONValue lastUpdateJSON = json.get("lastUpdate");
		ret.lastUpdate =  GwtSerDerUtils.DATE.deserialize(lastUpdateJSON);
		JSONValue nextUpdateJSON = json.get("nextUpdate");
		ret.nextUpdate =  GwtSerDerUtils.DATE.deserialize(nextUpdateJSON);
		JSONValue cacertItemUidJSON = json.get("cacertItemUid");
		ret.cacertItemUid =  GwtSerDerUtils.STRING.deserialize(cacertItemUidJSON);
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.SmimeRevocation ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("revocationDate")) {
			JSONValue revocationDateJSON = json.get("revocationDate");
			ret.revocationDate =  GwtSerDerUtils.DATE.deserialize(revocationDateJSON);
		}
		if (!childPropertiesToIgnore.contains("revocationReason")) {
			JSONValue revocationReasonJSON = json.get("revocationReason");
			ret.revocationReason =  GwtSerDerUtils.STRING.deserialize(revocationReasonJSON);
		}
		if (!childPropertiesToIgnore.contains("url")) {
			JSONValue urlJSON = json.get("url");
			ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
		}
		if (!childPropertiesToIgnore.contains("lastUpdate")) {
			JSONValue lastUpdateJSON = json.get("lastUpdate");
			ret.lastUpdate =  GwtSerDerUtils.DATE.deserialize(lastUpdateJSON);
		}
		if (!childPropertiesToIgnore.contains("nextUpdate")) {
			JSONValue nextUpdateJSON = json.get("nextUpdate");
			ret.nextUpdate =  GwtSerDerUtils.DATE.deserialize(nextUpdateJSON);
		}
		if (!childPropertiesToIgnore.contains("cacertItemUid")) {
			JSONValue cacertItemUidJSON = json.get("cacertItemUid");
			ret.cacertItemUid =  GwtSerDerUtils.STRING.deserialize(cacertItemUidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.smime.cacerts.api.SmimeRevocation o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.SmimeRevocation o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("revocationDate",  GwtSerDerUtils.DATE.serialize( o.revocationDate ));
		ret.put("revocationReason",  GwtSerDerUtils.STRING.serialize( o.revocationReason ));
		ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
		ret.put("lastUpdate",  GwtSerDerUtils.DATE.serialize( o.lastUpdate ));
		ret.put("nextUpdate",  GwtSerDerUtils.DATE.serialize( o.nextUpdate ));
		ret.put("cacertItemUid",  GwtSerDerUtils.STRING.serialize( o.cacertItemUid ));
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.SmimeRevocation o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("revocationDate")) {
			ret.put("revocationDate",  GwtSerDerUtils.DATE.serialize( o.revocationDate ));
		}
		if (!childPropertiesToIgnore.contains("revocationReason")) {
			ret.put("revocationReason",  GwtSerDerUtils.STRING.serialize( o.revocationReason ));
		}
		if (!childPropertiesToIgnore.contains("url")) {
			ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
		}
		if (!childPropertiesToIgnore.contains("lastUpdate")) {
			ret.put("lastUpdate",  GwtSerDerUtils.DATE.serialize( o.lastUpdate ));
		}
		if (!childPropertiesToIgnore.contains("nextUpdate")) {
			ret.put("nextUpdate",  GwtSerDerUtils.DATE.serialize( o.nextUpdate ));
		}
		if (!childPropertiesToIgnore.contains("cacertItemUid")) {
			ret.put("cacertItemUid",  GwtSerDerUtils.STRING.serialize( o.cacertItemUid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}