/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.smime.cacerts.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SmimeCacertGwtSerDer implements GwtSerDer<net.bluemind.smime.cacerts.api.SmimeCacert> {

	public SmimeCacertGwtSerDer( ) {
	}

	@Override
	public net.bluemind.smime.cacerts.api.SmimeCacert deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.smime.cacerts.api.SmimeCacert ret = new net.bluemind.smime.cacerts.api.SmimeCacert();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.SmimeCacert ret, JSONObject json) {
		JSONValue certJSON = json.get("cert");
		ret.cert =  GwtSerDerUtils.STRING.deserialize(certJSON);
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.SmimeCacert ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("cert")) {
			JSONValue certJSON = json.get("cert");
			ret.cert =  GwtSerDerUtils.STRING.deserialize(certJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.smime.cacerts.api.SmimeCacert o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.SmimeCacert o, JSONObject ret) {

		ret.put("cert",  GwtSerDerUtils.STRING.serialize( o.cert ));
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.SmimeCacert o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("cert")) {
			ret.put("cert",  GwtSerDerUtils.STRING.serialize( o.cert ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}