/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.smime.cacerts.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsSmimeRevocation extends net.bluemind.smime.cacerts.api.gwt.js.JsSmimeCertClient  {

	protected JsSmimeRevocation() {}

	public final native com.google.gwt.core.client.JsDate getRevocationDate()
	/*-{
       if(this["revocationDate"]) {
          return new Date(this["revocationDate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setRevocationDate(com.google.gwt.core.client.JsDate revocationDate)
	/*-{
       this["revocationDate"] =  ( revocationDate != null) ? revocationDate.getTime() : null;
	}-*/;

	public final native String getRevocationReason()
	/*-{
	return this["revocationReason"];
	}-*/;

	public final native void setRevocationReason(String revocationReason)
	/*-{
       this["revocationReason"] = revocationReason;
	}-*/;

	public final native String getUrl()
	/*-{
	return this["url"];
	}-*/;

	public final native void setUrl(String url)
	/*-{
       this["url"] = url;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getLastUpdate()
	/*-{
       if(this["lastUpdate"]) {
          return new Date(this["lastUpdate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setLastUpdate(com.google.gwt.core.client.JsDate lastUpdate)
	/*-{
       this["lastUpdate"] =  ( lastUpdate != null) ? lastUpdate.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getNextUpdate()
	/*-{
       if(this["nextUpdate"]) {
          return new Date(this["nextUpdate"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setNextUpdate(com.google.gwt.core.client.JsDate nextUpdate)
	/*-{
       this["nextUpdate"] =  ( nextUpdate != null) ? nextUpdate.getTime() : null;
	}-*/;

	public final native String getCacertItemUid()
	/*-{
	return this["cacertItemUid"];
	}-*/;

	public final native void setCacertItemUid(String cacertItemUid)
	/*-{
       this["cacertItemUid"] = cacertItemUid;
	}-*/;

	public static native  JsSmimeRevocation create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}