/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.smime.cacerts.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class SmimeRevocationSockJsEndpoint implements net.bluemind.smime.cacerts.api.ISmimeRevocationAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public SmimeRevocationSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/smime_revocation/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public SmimeRevocationSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void areRevoked(List<net.bluemind.smime.cacerts.api.SmimeCertClient> clients, final AsyncHandler<Set<net.bluemind.smime.cacerts.api.RevocationResult>> handler) {
		String postUri = "/revoked_clients";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.SmimeCertClientGwtSerDer()).serialize( clients);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Set<net.bluemind.smime.cacerts.api.RevocationResult>>(handler) {
					@Override
			protected Set<net.bluemind.smime.cacerts.api.RevocationResult> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.RevocationResultGwtSerDer()).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void fetch(net.bluemind.core.container.model.ItemValue<net.bluemind.smime.cacerts.api.SmimeCacert> cacert, final AsyncHandler<net.bluemind.smime.cacerts.api.SmimeCacertInfos> handler) {
		String postUri = "/fetch";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.SmimeCacertGwtSerDer()).serialize( cacert);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.smime.cacerts.api.SmimeCacertInfos>(handler) {
					@Override
			protected net.bluemind.smime.cacerts.api.SmimeCacertInfos handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.smime.cacerts.api.gwt.serder.SmimeCacertInfosGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void refreshDomainRevocations(final AsyncHandler<Void> handler) {
		String postUri = "/refresh_domain";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void refreshRevocations(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/refresh/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.smime.cacerts.api.ISmimeRevocationPromise promiseApi() {
		return new SmimeRevocationEndpointPromise(this);
	}

}
