/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.smime.cacerts.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class SmimeRevocationEndpointPromise implements net.bluemind.smime.cacerts.api.ISmimeRevocationPromise {

	private net.bluemind.smime.cacerts.api.ISmimeRevocationAsync impl;

	public SmimeRevocationEndpointPromise(net.bluemind.smime.cacerts.api.ISmimeRevocationAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Set<net.bluemind.smime.cacerts.api.RevocationResult>> areRevoked(List<net.bluemind.smime.cacerts.api.SmimeCertClient> clients  ) {
		
		CompletableFuture<Set<net.bluemind.smime.cacerts.api.RevocationResult>> ret = new CompletableFuture<Set<net.bluemind.smime.cacerts.api.RevocationResult>>();
		AsyncHandler<Set<net.bluemind.smime.cacerts.api.RevocationResult>> handler = new AsyncHandler<Set<net.bluemind.smime.cacerts.api.RevocationResult>>() {
			public void success(Set<net.bluemind.smime.cacerts.api.RevocationResult> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.areRevoked(clients,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.smime.cacerts.api.SmimeCacertInfos> fetch(net.bluemind.core.container.model.ItemValue<net.bluemind.smime.cacerts.api.SmimeCacert> cacert  ) {
		
		CompletableFuture<net.bluemind.smime.cacerts.api.SmimeCacertInfos> ret = new CompletableFuture<net.bluemind.smime.cacerts.api.SmimeCacertInfos>();
		AsyncHandler<net.bluemind.smime.cacerts.api.SmimeCacertInfos> handler = new AsyncHandler<net.bluemind.smime.cacerts.api.SmimeCacertInfos>() {
			public void success(net.bluemind.smime.cacerts.api.SmimeCacertInfos value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.fetch(cacert,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> refreshDomainRevocations() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.refreshDomainRevocations( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> refreshRevocations(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.refreshRevocations(uid,  handler);
		return ret;
	}

}
