/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.webappdata.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class WebAppDataGwtSerDer implements GwtSerDer<net.bluemind.webappdata.api.WebAppData> {

	public WebAppDataGwtSerDer( ) {
	}

	@Override
	public net.bluemind.webappdata.api.WebAppData deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.webappdata.api.WebAppData ret = new net.bluemind.webappdata.api.WebAppData();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.webappdata.api.WebAppData ret, JSONObject json) {
		JSONValue keyJSON = json.get("key");
		ret.key =  GwtSerDerUtils.STRING.deserialize(keyJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  GwtSerDerUtils.STRING.deserialize(valueJSON);
	}

	public void deserializeTo(net.bluemind.webappdata.api.WebAppData ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("key")) {
			JSONValue keyJSON = json.get("key");
			ret.key =  GwtSerDerUtils.STRING.deserialize(keyJSON);
		}
		if (!childPropertiesToIgnore.contains("value")) {
			JSONValue valueJSON = json.get("value");
			ret.value =  GwtSerDerUtils.STRING.deserialize(valueJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.webappdata.api.WebAppData o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.webappdata.api.WebAppData o, JSONObject ret) {

		ret.put("key",  GwtSerDerUtils.STRING.serialize( o.key ));
		ret.put("value",  GwtSerDerUtils.STRING.serialize( o.value ));
	}

	public void serializeTo(net.bluemind.webappdata.api.WebAppData o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("key")) {
			ret.put("key",  GwtSerDerUtils.STRING.serialize( o.key ));
		}
		if (!childPropertiesToIgnore.contains("value")) {
			ret.put("value",  GwtSerDerUtils.STRING.serialize( o.value ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}