/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.tests;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import javax.sql.DataSource;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.rest.ServerSideServiceProvider;

public class CqlTestContext implements BmContext {

	private SecurityContext sc;

	public CqlTestContext(SecurityContext sc) {
		this.sc = sc;
	}

	@Override
	public SecurityContext getSecurityContext() {
		return sc;
	}

	@Override
	public DataSource getDataSource() {
		return null;
	}

	@Override
	public DataSource getMailboxDataSource(String datalocation) {
		return null;
	}

	@Override
	public String dataSourceLocation(DataSource ds) {
		return null;
	}

	@Override
	public List<DataSource> getAllMailboxDataSource() {
		throw new UnsupportedOperationException("We are not JDBC based");
	}

	@Override
	public IServiceProvider getServiceProvider() {
		return ServerSideServiceProvider.getProvider(this);
	}

	@Override
	public IServiceProvider provider() {
		return ServerSideServiceProvider.getProvider(this);
	}

	@Override
	public BmContext su(SecurityContext ctx) {
		return new CqlTestContext(ctx);
	}

	@Override
	public BmContext su() {
		return new CqlTestContext(SecurityContext.SYSTEM);
	}

	@Override
	public BmContext su(String userUid, String domainUid) {
		return su(UUID.randomUUID().toString(), userUid, domainUid);
	}

	@Override
	public BmContext su(String sid, String userUid, String domainUid) {
		SecurityContext fresh = new SecurityContext(sid, userUid, userUid, Collections.emptyList(),
				Collections.emptyList(), Collections.emptyMap(), domainUid, "en", "junit-origin", false);
		return new CqlTestContext(fresh);
	}

	@Override
	public BmContext withRoles(Set<String> roles) {
		SecurityContext fresh = new SecurityContext(sc.getSessionId(), sc.getSubject(), sc.getSubjectDisplayName(),
				sc.getMemberOf(), List.copyOf(roles), sc.getRolesByOrgUnits(), sc.getContainerUid(), sc.getLang(),
				sc.getOrigin(), sc.isInteractive());
		return new CqlTestContext(fresh);
	}

	@Override
	public DataSourceType getStorageFlavor() {
		return DataSourceType.CQL;
	}

}
