/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class UserGwtSerDer implements GwtSerDer<net.bluemind.user.api.User> {

	private net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer parent = new  net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer();
	public UserGwtSerDer( ) {
	}

	@Override
	public net.bluemind.user.api.User deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.user.api.User ret = new net.bluemind.user.api.User();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.user.api.User ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue loginJSON = json.get("login");
		ret.login =  GwtSerDerUtils.STRING.deserialize(loginJSON);
		JSONValue passwordJSON = json.get("password");
		ret.password =  GwtSerDerUtils.STRING.deserialize(passwordJSON);
		JSONValue passwordLastChangeJSON = json.get("passwordLastChange");
		ret.passwordLastChange =  GwtSerDerUtils.DATE.deserialize(passwordLastChangeJSON);
		JSONValue passwordMustChangeJSON = json.get("passwordMustChange");
		ret.passwordMustChange =  GwtSerDerUtils.BOOLEAN.deserialize(passwordMustChangeJSON);
		JSONValue passwordNeverExpiresJSON = json.get("passwordNeverExpires");
		ret.passwordNeverExpires =  GwtSerDerUtils.BOOLEAN.deserialize(passwordNeverExpiresJSON);
		JSONValue contactInfosJSON = json.get("contactInfos");
		ret.contactInfos =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(contactInfosJSON);
		JSONValue routingJSON = json.get("routing");
		ret.routing =  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().deserialize(routingJSON);
		JSONValue accountTypeJSON = json.get("accountType");
		ret.accountType =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().deserialize(accountTypeJSON);
		JSONValue quotaJSON = json.get("quota");
		ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		JSONValue mailboxCopyGuidJSON = json.get("mailboxCopyGuid");
		ret.mailboxCopyGuid =  GwtSerDerUtils.STRING.deserialize(mailboxCopyGuidJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
	}

	public void deserializeTo(net.bluemind.user.api.User ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("login")) {
			JSONValue loginJSON = json.get("login");
			ret.login =  GwtSerDerUtils.STRING.deserialize(loginJSON);
		}
		if (!childPropertiesToIgnore.contains("password")) {
			JSONValue passwordJSON = json.get("password");
			ret.password =  GwtSerDerUtils.STRING.deserialize(passwordJSON);
		}
		if (!childPropertiesToIgnore.contains("passwordLastChange")) {
			JSONValue passwordLastChangeJSON = json.get("passwordLastChange");
			ret.passwordLastChange =  GwtSerDerUtils.DATE.deserialize(passwordLastChangeJSON);
		}
		if (!childPropertiesToIgnore.contains("passwordMustChange")) {
			JSONValue passwordMustChangeJSON = json.get("passwordMustChange");
			ret.passwordMustChange =  GwtSerDerUtils.BOOLEAN.deserialize(passwordMustChangeJSON);
		}
		if (!childPropertiesToIgnore.contains("passwordNeverExpires")) {
			JSONValue passwordNeverExpiresJSON = json.get("passwordNeverExpires");
			ret.passwordNeverExpires =  GwtSerDerUtils.BOOLEAN.deserialize(passwordNeverExpiresJSON);
		}
		if (!childPropertiesToIgnore.contains("contactInfos")) {
			JSONValue contactInfosJSON = json.get("contactInfos");
			ret.contactInfos =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(contactInfosJSON);
		}
		if (!childPropertiesToIgnore.contains("routing")) {
			JSONValue routingJSON = json.get("routing");
			ret.routing =  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().deserialize(routingJSON);
		}
		if (!childPropertiesToIgnore.contains("accountType")) {
			JSONValue accountTypeJSON = json.get("accountType");
			ret.accountType =  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().deserialize(accountTypeJSON);
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			JSONValue quotaJSON = json.get("quota");
			ret.quota =  GwtSerDerUtils.INT.deserialize(quotaJSON);
		}
		if (!childPropertiesToIgnore.contains("mailboxCopyGuid")) {
			JSONValue mailboxCopyGuidJSON = json.get("mailboxCopyGuid");
			ret.mailboxCopyGuid =  GwtSerDerUtils.STRING.deserialize(mailboxCopyGuidJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.user.api.User o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.user.api.User o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("login",  GwtSerDerUtils.STRING.serialize( o.login ));
		ret.put("password",  GwtSerDerUtils.STRING.serialize( o.password ));
		ret.put("passwordLastChange",  GwtSerDerUtils.DATE.serialize( o.passwordLastChange ));
		ret.put("passwordMustChange",  GwtSerDerUtils.BOOLEAN.serialize( o.passwordMustChange ));
		ret.put("passwordNeverExpires",  GwtSerDerUtils.BOOLEAN.serialize( o.passwordNeverExpires ));
		ret.put("contactInfos",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.contactInfos ));
		ret.put("routing",  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().serialize( o.routing ));
		ret.put("accountType",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().serialize( o.accountType ));
		ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		ret.put("mailboxCopyGuid",  GwtSerDerUtils.STRING.serialize( o.mailboxCopyGuid ));
		ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
	}

	public void serializeTo(net.bluemind.user.api.User o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("login")) {
			ret.put("login",  GwtSerDerUtils.STRING.serialize( o.login ));
		}
		if (!childPropertiesToIgnore.contains("password")) {
			ret.put("password",  GwtSerDerUtils.STRING.serialize( o.password ));
		}
		if (!childPropertiesToIgnore.contains("passwordLastChange")) {
			ret.put("passwordLastChange",  GwtSerDerUtils.DATE.serialize( o.passwordLastChange ));
		}
		if (!childPropertiesToIgnore.contains("passwordMustChange")) {
			ret.put("passwordMustChange",  GwtSerDerUtils.BOOLEAN.serialize( o.passwordMustChange ));
		}
		if (!childPropertiesToIgnore.contains("passwordNeverExpires")) {
			ret.put("passwordNeverExpires",  GwtSerDerUtils.BOOLEAN.serialize( o.passwordNeverExpires ));
		}
		if (!childPropertiesToIgnore.contains("contactInfos")) {
			ret.put("contactInfos",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.contactInfos ));
		}
		if (!childPropertiesToIgnore.contains("routing")) {
			ret.put("routing",  new net.bluemind.mailbox.api.gwt.serder.MailboxRoutingGwtSerDer().serialize( o.routing ));
		}
		if (!childPropertiesToIgnore.contains("accountType")) {
			ret.put("accountType",  new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().serialize( o.accountType ));
		}
		if (!childPropertiesToIgnore.contains("quota")) {
			ret.put("quota",  GwtSerDerUtils.INT.serialize( o.quota ));
		}
		if (!childPropertiesToIgnore.contains("mailboxCopyGuid")) {
			ret.put("mailboxCopyGuid",  GwtSerDerUtils.STRING.serialize( o.mailboxCopyGuid ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}