/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.imap.vt.cmd;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import io.vertx.core.buffer.Buffer;
import net.bluemind.imap.vt.parsing.IncomingChunk;
import net.bluemind.imap.vt.parsing.UTF7Converter;

public class StatusCommand extends TaggedCommand<Map<String, Integer>> {

	private String folder;
	private String[] tokens;

	public StatusCommand(CommandContext ctx, String folder, String... tokens) {
		super(ctx);
		this.folder = folder;
		this.tokens = tokens;
	}

	@Override
	protected void buildCommand(Buffer b) {
		b.appendString("STATUS \"").appendString(UTF7Converter.encode(folder)).appendString("\"");
		b.appendString(Arrays.stream(tokens).collect(Collectors.joining(" ", " (", ")")));
	}

	@Override
	protected Map<String, Integer> processChunks(List<IncomingChunk> chunks) throws IOException {
		var last = chunks.getLast();
		for (var ic : chunks) {
			if (ic == last) {
				break;
			}
			String t = ic.pieces().getFirst().txt();
			int start = -1;
			int end = -1;
			if (t.startsWith("* STATUS") && (start = t.lastIndexOf('(')) != -1 && (end = t.indexOf(')', start)) != -1) {
				// UNSEEN 5 UIDNEXT 6
				String spl = t.substring(start + 1, end);
				String[] tokenValues = spl.split(" ");
				Map<String, Integer> ret = new HashMap<>();
				for (int i = 0; i < tokenValues.length; i += 2) {
					ret.put(tokenValues[i], Integer.parseInt(tokenValues[i + 1]));
				}
				return ret;
			}
		}
		return Collections.emptyMap();
	}

}
