/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.MailFilter> {

	public MailFilterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.MailFilter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.MailFilter ret = new net.bluemind.mailbox.api.MailFilter();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter ret, JSONObject json) {
		JSONValue rulesJSON = json.get("rules");
		ret.rules =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).deserialize(rulesJSON);
		JSONValue forwardingJSON = json.get("forwarding");
		ret.forwarding =  new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().deserialize(forwardingJSON);
		JSONValue vacationJSON = json.get("vacation");
		ret.vacation =  new net.bluemind.mailbox.api.gwt.serder.MailFilterVacationGwtSerDer().deserialize(vacationJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("rules")) {
			JSONValue rulesJSON = json.get("rules");
			ret.rules =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).deserialize(rulesJSON);
		}
		if (!childPropertiesToIgnore.contains("forwarding")) {
			JSONValue forwardingJSON = json.get("forwarding");
			ret.forwarding =  new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().deserialize(forwardingJSON);
		}
		if (!childPropertiesToIgnore.contains("vacation")) {
			JSONValue vacationJSON = json.get("vacation");
			ret.vacation =  new net.bluemind.mailbox.api.gwt.serder.MailFilterVacationGwtSerDer().deserialize(vacationJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.MailFilter o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter o, JSONObject ret) {

		ret.put("rules",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).serialize( o.rules ));
		ret.put("forwarding",  new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().serialize( o.forwarding ));
		ret.put("vacation",  new net.bluemind.mailbox.api.gwt.serder.MailFilterVacationGwtSerDer().serialize( o.vacation ));
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("rules")) {
			ret.put("rules",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleGwtSerDer()).serialize( o.rules ));
		}
		if (!childPropertiesToIgnore.contains("forwarding")) {
			ret.put("forwarding",  new net.bluemind.mailbox.api.gwt.serder.MailFilterForwardingGwtSerDer().serialize( o.forwarding ));
		}
		if (!childPropertiesToIgnore.contains("vacation")) {
			ret.put("vacation",  new net.bluemind.mailbox.api.gwt.serder.MailFilterVacationGwtSerDer().serialize( o.vacation ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}