package net.bluemind.exchange.mapi.service.internal;

import java.util.List;

import net.bluemind.core.rest.BmContext;
import net.bluemind.exchange.mapi.api.IMapiPidMapping;
import net.bluemind.exchange.mapi.api.MapiPidMapping;
import net.bluemind.exchange.mapi.hook.IMapiPidMappingHook;
import net.bluemind.exchange.mapi.hook.MapiPidMappingHooks;
import net.bluemind.exchange.mapi.repository.IMapiPidMappingStore;
import net.bluemind.repository.provider.RepositoryProvider;

public class MapiPidMappingService implements IMapiPidMapping {

	public static final int START = 0x9000;
	private IMapiPidMappingStore store;
	private final List<IMapiPidMappingHook> hooks;

	public MapiPidMappingService(BmContext context) {
		store = RepositoryProvider.instance(IMapiPidMappingStore.class, context);
		hooks = MapiPidMappingHooks.get();
	}

	@Override
	public MapiPidMapping get(Integer id) {
		return store.get(id);
	}

	@Override
	public Integer save(String name) {
		int newId = store.store(name);
		MapiPidMapping pid = new MapiPidMapping(newId, name);
		hooks.forEach(hook -> hook.postSave(pid));
		return newId;
	}

	@Override
	public List<MapiPidMapping> getAll() {
		return store.getAll();
	}

	@Override
	public void saveBatch(List<MapiPidMapping> batch) {
		Integer maxId = store.storeBatch(batch);
		hooks.forEach(hook -> hook.postSaveBatch(maxId, batch));
	}

}
