/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.device.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DeviceGwtSerDer implements GwtSerDer<net.bluemind.device.api.Device> {

	public DeviceGwtSerDer( ) {
	}

	@Override
	public net.bluemind.device.api.Device deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.device.api.Device ret = new net.bluemind.device.api.Device();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.device.api.Device ret, JSONObject json) {
		JSONValue identifierJSON = json.get("identifier");
		ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		JSONValue wipeDateJSON = json.get("wipeDate");
		ret.wipeDate =  GwtSerDerUtils.DATE.deserialize(wipeDateJSON);
		JSONValue wipeByJSON = json.get("wipeBy");
		ret.wipeBy =  GwtSerDerUtils.STRING.deserialize(wipeByJSON);
		JSONValue unwipeDateJSON = json.get("unwipeDate");
		ret.unwipeDate =  GwtSerDerUtils.DATE.deserialize(unwipeDateJSON);
		JSONValue unwipeByJSON = json.get("unwipeBy");
		ret.unwipeBy =  GwtSerDerUtils.STRING.deserialize(unwipeByJSON);
		JSONValue isWipedJSON = json.get("isWiped");
		ret.isWiped =  GwtSerDerUtils.BOOLEAN.deserialize(isWipedJSON);
		JSONValue wipeModeJSON = json.get("wipeMode");
		ret.wipeMode =  new net.bluemind.device.api.gwt.serder.WipeModeGwtSerDer().deserialize(wipeModeJSON);
		JSONValue hasPartnershipJSON = json.get("hasPartnership");
		ret.hasPartnership =  GwtSerDerUtils.BOOLEAN.deserialize(hasPartnershipJSON);
		JSONValue policyJSON = json.get("policy");
		ret.policy =  GwtSerDerUtils.INT.deserialize(policyJSON);
		JSONValue lastSyncJSON = json.get("lastSync");
		ret.lastSync =  GwtSerDerUtils.DATE.deserialize(lastSyncJSON);
		JSONValue protocolVersionJSON = json.get("protocolVersion");
		ret.protocolVersion =  GwtSerDerUtils.DOUBLE.deserialize(protocolVersionJSON);
	}

	public void deserializeTo(net.bluemind.device.api.Device ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("identifier")) {
			JSONValue identifierJSON = json.get("identifier");
			ret.identifier =  GwtSerDerUtils.STRING.deserialize(identifierJSON);
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("wipeDate")) {
			JSONValue wipeDateJSON = json.get("wipeDate");
			ret.wipeDate =  GwtSerDerUtils.DATE.deserialize(wipeDateJSON);
		}
		if (!childPropertiesToIgnore.contains("wipeBy")) {
			JSONValue wipeByJSON = json.get("wipeBy");
			ret.wipeBy =  GwtSerDerUtils.STRING.deserialize(wipeByJSON);
		}
		if (!childPropertiesToIgnore.contains("unwipeDate")) {
			JSONValue unwipeDateJSON = json.get("unwipeDate");
			ret.unwipeDate =  GwtSerDerUtils.DATE.deserialize(unwipeDateJSON);
		}
		if (!childPropertiesToIgnore.contains("unwipeBy")) {
			JSONValue unwipeByJSON = json.get("unwipeBy");
			ret.unwipeBy =  GwtSerDerUtils.STRING.deserialize(unwipeByJSON);
		}
		if (!childPropertiesToIgnore.contains("isWiped")) {
			JSONValue isWipedJSON = json.get("isWiped");
			ret.isWiped =  GwtSerDerUtils.BOOLEAN.deserialize(isWipedJSON);
		}
		if (!childPropertiesToIgnore.contains("wipeMode")) {
			JSONValue wipeModeJSON = json.get("wipeMode");
			ret.wipeMode =  new net.bluemind.device.api.gwt.serder.WipeModeGwtSerDer().deserialize(wipeModeJSON);
		}
		if (!childPropertiesToIgnore.contains("hasPartnership")) {
			JSONValue hasPartnershipJSON = json.get("hasPartnership");
			ret.hasPartnership =  GwtSerDerUtils.BOOLEAN.deserialize(hasPartnershipJSON);
		}
		if (!childPropertiesToIgnore.contains("policy")) {
			JSONValue policyJSON = json.get("policy");
			ret.policy =  GwtSerDerUtils.INT.deserialize(policyJSON);
		}
		if (!childPropertiesToIgnore.contains("lastSync")) {
			JSONValue lastSyncJSON = json.get("lastSync");
			ret.lastSync =  GwtSerDerUtils.DATE.deserialize(lastSyncJSON);
		}
		if (!childPropertiesToIgnore.contains("protocolVersion")) {
			JSONValue protocolVersionJSON = json.get("protocolVersion");
			ret.protocolVersion =  GwtSerDerUtils.DOUBLE.deserialize(protocolVersionJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.device.api.Device o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.device.api.Device o, JSONObject ret) {

		ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		ret.put("wipeDate",  GwtSerDerUtils.DATE.serialize( o.wipeDate ));
		ret.put("wipeBy",  GwtSerDerUtils.STRING.serialize( o.wipeBy ));
		ret.put("unwipeDate",  GwtSerDerUtils.DATE.serialize( o.unwipeDate ));
		ret.put("unwipeBy",  GwtSerDerUtils.STRING.serialize( o.unwipeBy ));
		ret.put("isWiped",  GwtSerDerUtils.BOOLEAN.serialize( o.isWiped ));
		ret.put("wipeMode",  new net.bluemind.device.api.gwt.serder.WipeModeGwtSerDer().serialize( o.wipeMode ));
		ret.put("hasPartnership",  GwtSerDerUtils.BOOLEAN.serialize( o.hasPartnership ));
		ret.put("policy",  GwtSerDerUtils.INT.serialize( o.policy ));
		ret.put("lastSync",  GwtSerDerUtils.DATE.serialize( o.lastSync ));
		ret.put("protocolVersion",  GwtSerDerUtils.DOUBLE.serialize( o.protocolVersion ));
	}

	public void serializeTo(net.bluemind.device.api.Device o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("identifier")) {
			ret.put("identifier",  GwtSerDerUtils.STRING.serialize( o.identifier ));
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("wipeDate")) {
			ret.put("wipeDate",  GwtSerDerUtils.DATE.serialize( o.wipeDate ));
		}
		if (!childPropertiesToIgnore.contains("wipeBy")) {
			ret.put("wipeBy",  GwtSerDerUtils.STRING.serialize( o.wipeBy ));
		}
		if (!childPropertiesToIgnore.contains("unwipeDate")) {
			ret.put("unwipeDate",  GwtSerDerUtils.DATE.serialize( o.unwipeDate ));
		}
		if (!childPropertiesToIgnore.contains("unwipeBy")) {
			ret.put("unwipeBy",  GwtSerDerUtils.STRING.serialize( o.unwipeBy ));
		}
		if (!childPropertiesToIgnore.contains("isWiped")) {
			ret.put("isWiped",  GwtSerDerUtils.BOOLEAN.serialize( o.isWiped ));
		}
		if (!childPropertiesToIgnore.contains("wipeMode")) {
			ret.put("wipeMode",  new net.bluemind.device.api.gwt.serder.WipeModeGwtSerDer().serialize( o.wipeMode ));
		}
		if (!childPropertiesToIgnore.contains("hasPartnership")) {
			ret.put("hasPartnership",  GwtSerDerUtils.BOOLEAN.serialize( o.hasPartnership ));
		}
		if (!childPropertiesToIgnore.contains("policy")) {
			ret.put("policy",  GwtSerDerUtils.INT.serialize( o.policy ));
		}
		if (!childPropertiesToIgnore.contains("lastSync")) {
			ret.put("lastSync",  GwtSerDerUtils.DATE.serialize( o.lastSync ));
		}
		if (!childPropertiesToIgnore.contains("protocolVersion")) {
			ret.put("protocolVersion",  GwtSerDerUtils.DOUBLE.serialize( o.protocolVersion ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}