#
#  BEGIN LICENSE
#  Copyright (c) Blue Mind SAS, 2012-2016
# 
#  This file is part of BlueMind. BlueMind is a messaging and collaborative
#  solution.
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of either the GNU Affero General Public License as
#  published by the Free Software Foundation (version 3 of the License).
# 
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# 
#  See LICENSE.txt
#  END LICENSE
#
import requests
from netbluemind.python import serder

from netbluemind.mailbox.api.rules.actions.MailFilterRuleAction import MailFilterRuleAction
from netbluemind.mailbox.api.rules.actions.MailFilterRuleAction import __MailFilterRuleActionSerDer__
class MailFilterRuleActionMove (MailFilterRuleAction):
    def __init__( self):
        MailFilterRuleAction.__init__(self)
        self.subtree = None
        self.id = None
        self.folder = None
        pass

class __MailFilterRuleActionMoveSerDer__:
    def __init__( self ):
        pass

    def parse(self, value):
        if(value == None):
            return None
        instance = MailFilterRuleActionMove()
        
        self.parseInternal(value, instance)
        return instance

    def parseInternal(self, value, instance):
        __MailFilterRuleActionSerDer__().parseInternal(value,instance)
        subtreeValue = value['subtree']
        instance.subtree = serder.STRING.parse(subtreeValue)
        idValue = value['id']
        instance.id = serder.LONG.parse(idValue)
        folderValue = value['folder']
        instance.folder = serder.STRING.parse(folderValue)
        return instance

    def encode(self, value):
        if(value == None):
            return None
        instance = dict()
        self.encodeInternal(value,instance)
        return instance

    def encodeInternal(self, value, instance):
        __MailFilterRuleActionSerDer__().encodeInternal(value,instance)

        subtreeValue = value.subtree
        instance["subtree"] = serder.STRING.encode(subtreeValue)
        idValue = value.id
        instance["id"] = serder.LONG.encode(idValue)
        folderValue = value.folder
        instance["folder"] = serder.STRING.encode(folderValue)
        return instance

