#
#  BEGIN LICENSE
#  Copyright (c) Blue Mind SAS, 2012-2016
# 
#  This file is part of BlueMind. BlueMind is a messaging and collaborative
#  solution.
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of either the GNU Affero General Public License as
#  published by the Free Software Foundation (version 3 of the License).
# 
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# 
#  See LICENSE.txt
#  END LICENSE
#
import requests
import json
from netbluemind.python import serder
from netbluemind.python.client import BaseEndpoint

ITask_VERSION = "5.4.2696"

class ITask(BaseEndpoint):
    def __init__(self, apiKey, url ,taskId ):
        self.url = url
        self.apiKey = apiKey
        self.base = url +'/tasks/{taskId}'
        self.taskId_ = taskId
        self.base = self.base.replace('{taskId}',taskId)

    def getCurrentLogs (self, offset ):
        postUri = "/_currentLogs";
        __data__ = None
        __encoded__ = None
        queryParams = {  'offset': offset   };

        response = requests.get( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ITask_VERSION}, data = __encoded__);
        return self.handleResult__(serder.ListSerDer(serder.STRING), response)
    def log (self):
        postUri = "/_log";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.get( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ITask_VERSION}, data = __encoded__);
        return response.content
    def status (self):
        postUri = "";
        __data__ = None
        __encoded__ = None
        queryParams = {  };

        response = requests.get( self.base + postUri, params = queryParams, verify=False, headers = {'X-BM-ApiKey' : self.apiKey, 'Accept' : 'application/json', 'X-BM-ClientVersion' : ITask_VERSION}, data = __encoded__);
        from netbluemind.core.task.api.TaskStatus import TaskStatus
        from netbluemind.core.task.api.TaskStatus import __TaskStatusSerDer__
        return self.handleResult__(__TaskStatusSerDer__(), response)
