import { asn1, util } from "node-forge";

const CONTENT_PATH = "0.1.0.2.2.1";

function containsContent(path: number[]): boolean {
    return CONTENT_PATH.startsWith(`${path.join(".")}.`);
}

export function toBer(obj: asn1.Asn1, path: number[] = [0]): util.ByteStringBuffer {
    if (!containsContent(path)) {
        return asn1.toDer(obj);
    }

    // BER byte sequence is [TAG_BYTE] [0x80] [CONTENT...] [0x00] [0x00]
    const bytes = util.createBuffer();

    // [TAG_BYTE]: Creates a tag byte indicating this is a constructed element
    const tagByte = obj.tagClass | obj.type | 0x20;
    bytes.putByte(tagByte);

    // [0x80]: Indefinite Length Indicator
    bytes.putByte(0x80);

    // [CONTENT]
    if (obj.value && Array.isArray(obj.value)) {
        for (let i = 0; i < obj.value.length; ++i) {
            if (obj.value[i] !== undefined) {
                bytes.putBuffer(toBer(obj.value[i], path.concat(i)));
            }
        }
    }

    // [0x00] [0x00]: End-of-Contents Octets
    bytes.putBytes("\x00\x00");

    return bytes;
}
