/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.tag.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class TagChangesGwtSerDer implements GwtSerDer<net.bluemind.tag.api.TagChanges> {

	public TagChangesGwtSerDer( ) {
	}

	@Override
	public net.bluemind.tag.api.TagChanges deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.tag.api.TagChanges ret = new net.bluemind.tag.api.TagChanges();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.tag.api.TagChanges ret, JSONObject json) {
		JSONValue addJSON = json.get("add");
		ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemAddGwtSerDer()).deserialize(addJSON);
		JSONValue modifyJSON = json.get("modify");
		ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		JSONValue deleteJSON = json.get("delete");
		ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
	}

	public void deserializeTo(net.bluemind.tag.api.TagChanges ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("add")) {
			JSONValue addJSON = json.get("add");
			ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemAddGwtSerDer()).deserialize(addJSON);
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			JSONValue modifyJSON = json.get("modify");
			ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			JSONValue deleteJSON = json.get("delete");
			ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.tag.api.TagChanges o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.tag.api.TagChanges o, JSONObject ret) {

		ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemAddGwtSerDer()).serialize( o.add ));
		ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemModifyGwtSerDer()).serialize( o.modify ));
		ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemDeleteGwtSerDer()).serialize( o.delete ));
	}

	public void serializeTo(net.bluemind.tag.api.TagChanges o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("add")) {
			ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemAddGwtSerDer()).serialize( o.add ));
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemModifyGwtSerDer()).serialize( o.modify ));
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagChangesItemDeleteGwtSerDer()).serialize( o.delete ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}