package net.bluemind.webmodule.server;

import java.util.List;

import net.bluemind.eclipse.common.RunnableExtensionLoader;
import net.bluemind.webmodule.server.project.ProjectFactory;

public class ProjectFactoryRegistry {

	private List<ProjectFactory> factories;

	public ProjectFactoryRegistry() {
		RunnableExtensionLoader<ProjectFactory> plateform = new RunnableExtensionLoader<ProjectFactory>();
		factories = plateform.loadExtensionsWithPriority("net.bluemind.webmodule", "server",
				"project-factory", "class");
	}
	
	public ProjectFactory get(String type) {
		return factories.stream().filter(factory -> factory.canHandle(type)).findFirst().get();
	}
}
