/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.protocol.ShardingInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultNode
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile EndPoint endPoint;
    private volatile transient NodeMetricUpdater metricUpdater;
    volatile InetSocketAddress broadcastRpcAddress;
    volatile InetSocketAddress broadcastAddress;
    volatile InetSocketAddress listenAddress;
    volatile String datacenter;
    volatile String rack;
    volatile Version cassandraVersion;
    volatile Set<String> rawTokens;
    volatile Map<String, Object> extras;
    volatile UUID hostId;
    volatile UUID schemaVersion;
    volatile NodeState state;
    volatile int openConnections;
    volatile int reconnections;
    volatile long upSinceMillis;
    volatile NodeDistance distance;
    private volatile ShardingInfo shardingInfo;

    public DefaultNode(EndPoint endPoint, InternalDriverContext context) {
        this.endPoint = endPoint;
        this.state = NodeState.UNKNOWN;
        this.distance = NodeDistance.IGNORED;
        this.rawTokens = Collections.emptySet();
        this.extras = Collections.emptyMap();
        this.metricUpdater = context.getMetricsFactory().newNodeUpdater(this);
        this.upSinceMillis = -1L;
        this.shardingInfo = null;
    }

    @Override
    @NonNull
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(@NonNull EndPoint newEndPoint, @NonNull InternalDriverContext context) {
        if (!newEndPoint.equals(this.endPoint)) {
            this.endPoint = newEndPoint;
            NodeMetricUpdater previousMetricUpdater = this.metricUpdater;
            if (!(previousMetricUpdater instanceof NoopNodeMetricUpdater)) {
                this.metricUpdater = context.getMetricsFactory().newNodeUpdater(this);
            }
        }
    }

    @Override
    @NonNull
    public Optional<InetSocketAddress> getBroadcastRpcAddress() {
        return Optional.ofNullable(this.broadcastRpcAddress);
    }

    @Override
    @NonNull
    public Optional<InetSocketAddress> getBroadcastAddress() {
        return Optional.ofNullable(this.broadcastAddress);
    }

    @Override
    @NonNull
    public Optional<InetSocketAddress> getListenAddress() {
        return Optional.ofNullable(this.listenAddress);
    }

    @Override
    @Nullable
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    @Nullable
    public String getRack() {
        return this.rack;
    }

    @Override
    @Nullable
    public Version getCassandraVersion() {
        return this.cassandraVersion;
    }

    @Override
    @Nullable
    public UUID getHostId() {
        return this.hostId;
    }

    @Override
    @Nullable
    public UUID getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    @NonNull
    public Map<String, Object> getExtras() {
        return this.extras;
    }

    @Override
    @NonNull
    public NodeState getState() {
        return this.state;
    }

    @Override
    public long getUpSinceMillis() {
        return this.upSinceMillis;
    }

    @Override
    public int getOpenConnections() {
        return this.openConnections;
    }

    @Override
    public boolean isReconnecting() {
        return this.reconnections > 0;
    }

    @Override
    @NonNull
    public NodeDistance getDistance() {
        return this.distance;
    }

    public NodeMetricUpdater getMetricUpdater() {
        return this.metricUpdater;
    }

    public String toString() {
        return String.format("Node(endPoint=%s, hostId=%s, hashCode=%x)", this.getEndPoint(), this.getHostId(), this.hashCode());
    }

    public Set<String> getRawTokens() {
        return this.rawTokens;
    }

    @Override
    @Nullable
    public ShardingInfo getShardingInfo() {
        return this.shardingInfo;
    }

    public void setShardingInfo(ShardingInfo shardingInfo) {
        this.shardingInfo = shardingInfo;
    }
}

