/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TabletMap;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultTabletMap;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultTokenMap;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.NanoTime;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultMetadata
implements Metadata {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMetadata.class);
    public static DefaultMetadata EMPTY = new DefaultMetadata(Collections.emptyMap(), Collections.emptyMap(), null, null, DefaultTabletMap.emptyMap());
    protected final Map<UUID, Node> nodes;
    protected final Map<CqlIdentifier, KeyspaceMetadata> keyspaces;
    protected final TokenMap tokenMap;
    protected final String clusterName;
    protected final TabletMap tabletMap;

    protected DefaultMetadata(Map<UUID, Node> nodes, Map<CqlIdentifier, KeyspaceMetadata> keyspaces, TokenMap tokenMap, String clusterName) {
        this(nodes, keyspaces, tokenMap, clusterName, DefaultTabletMap.emptyMap());
    }

    protected DefaultMetadata(Map<UUID, Node> nodes, Map<CqlIdentifier, KeyspaceMetadata> keyspaces, TokenMap tokenMap, String clusterName, TabletMap tabletMap) {
        this.nodes = nodes;
        this.keyspaces = keyspaces;
        this.tokenMap = tokenMap;
        this.clusterName = clusterName;
        this.tabletMap = tabletMap;
    }

    @Override
    @NonNull
    public Map<UUID, Node> getNodes() {
        return this.nodes;
    }

    @Override
    @NonNull
    public Map<CqlIdentifier, KeyspaceMetadata> getKeyspaces() {
        return this.keyspaces;
    }

    @Override
    @NonNull
    public Optional<TokenMap> getTokenMap() {
        return Optional.ofNullable(this.tokenMap);
    }

    @Override
    public TabletMap getTabletMap() {
        return this.tabletMap;
    }

    @Override
    @NonNull
    public Optional<String> getClusterName() {
        return Optional.ofNullable(this.clusterName);
    }

    public DefaultMetadata withNodes(Map<UUID, Node> newNodes, boolean tokenMapEnabled, boolean tokensChanged, TokenFactory tokenFactory, InternalDriverContext context) {
        boolean forceFullRebuild = tokensChanged || !newNodes.equals(this.nodes);
        return new DefaultMetadata(ImmutableMap.copyOf(newNodes), this.keyspaces, this.rebuildTokenMap(newNodes, this.keyspaces, tokenMapEnabled, forceFullRebuild, tokenFactory, context), context.getChannelFactory().getClusterName(), this.tabletMap);
    }

    public DefaultMetadata withTabletMap(TabletMap newTabletMap) {
        return new DefaultMetadata(this.nodes, this.keyspaces, this.tokenMap, this.clusterName, newTabletMap);
    }

    public DefaultMetadata withSchema(Map<CqlIdentifier, KeyspaceMetadata> newKeyspaces, boolean tokenMapEnabled, InternalDriverContext context) {
        return new DefaultMetadata(this.nodes, ImmutableMap.copyOf(newKeyspaces), this.rebuildTokenMap(this.nodes, newKeyspaces, tokenMapEnabled, false, null, context), context.getChannelFactory().getClusterName(), this.tabletMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TokenMap rebuildTokenMap(Map<UUID, Node> newNodes, Map<CqlIdentifier, KeyspaceMetadata> newKeyspaces, boolean tokenMapEnabled, boolean forceFullRebuild, TokenFactory tokenFactory, InternalDriverContext context) {
        String logPrefix = context.getSessionName();
        ReplicationStrategyFactory replicationStrategyFactory = context.getReplicationStrategyFactory();
        if (!tokenMapEnabled) {
            LOG.debug("[{}] Token map is disabled, skipping", (Object)logPrefix);
            return this.tokenMap;
        }
        long start = System.nanoTime();
        try {
            DefaultTokenMap oldTokenMap = (DefaultTokenMap)this.tokenMap;
            if (oldTokenMap == null) {
                if (tokenFactory == null) {
                    LOG.debug("[{}] Building initial token map but the token factory is missing, skipping", (Object)logPrefix);
                    TokenMap tokenMap = null;
                    return tokenMap;
                }
                LOG.debug("[{}] Building initial token map", (Object)logPrefix);
                DefaultTokenMap defaultTokenMap = DefaultTokenMap.build(newNodes.values(), newKeyspaces.values(), tokenFactory, replicationStrategyFactory, logPrefix);
                return defaultTokenMap;
            }
            if (forceFullRebuild) {
                LOG.debug("[{}] Updating token map but some nodes/tokens have changed, full rebuild", (Object)logPrefix);
                DefaultTokenMap defaultTokenMap = DefaultTokenMap.build(newNodes.values(), newKeyspaces.values(), oldTokenMap.getTokenFactory(), replicationStrategyFactory, logPrefix);
                return defaultTokenMap;
            }
            LOG.debug("[{}] Refreshing token map (only schema has changed)", (Object)logPrefix);
            DefaultTokenMap defaultTokenMap = oldTokenMap.refresh(newNodes.values(), newKeyspaces.values(), replicationStrategyFactory);
            return defaultTokenMap;
        }
        catch (Throwable t) {
            Loggers.warnWithException(LOG, "[{}] Unexpected error while refreshing token map, keeping previous version", logPrefix, t);
            TokenMap tokenMap = this.tokenMap;
            return tokenMap;
        }
        finally {
            LOG.debug("[{}] Rebuilding token map took {}", (Object)logPrefix, (Object)NanoTime.formatTimeSince(start));
        }
    }
}

