/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.datafaker.shaded.curiousoddman.rgxgen.model.SymbolRange;
import net.datafaker.shaded.curiousoddman.rgxgen.parsing.dflt.ConstantsProvider;
import net.datafaker.shaded.curiousoddman.rgxgen.util.chars.CharList;

public final class Util {
    public static String repeatChar(char c, int times) {
        if (times < 0) {
            return "";
        }
        char[] result = new char[times];
        Arrays.fill(result, c);
        return new String(result);
    }

    public static String randomlyChangeCase(Random rnd, String input) {
        StringBuilder sb = new StringBuilder(input);
        for (int i = 0; i < sb.length(); ++i) {
            char currentChar = sb.charAt(i);
            if (Character.isUpperCase(currentChar) && rnd.nextBoolean()) {
                sb.setCharAt(i, Character.toLowerCase(currentChar));
                continue;
            }
            if (!Character.isLowerCase(currentChar) || !rnd.nextBoolean()) continue;
            sb.setCharAt(i, Character.toUpperCase(currentChar));
        }
        return sb.toString();
    }

    public static BigInteger countCaseInsensitiveVariations(String value) {
        int switchableCase = value.chars().map(c -> Character.isUpperCase(c) || Character.isLowerCase(c) ? 1 : 0).sum();
        return ConstantsProvider.BIG_INTEGER_TWO.pow(switchableCase);
    }

    public static OptionalInt indexOfNextCaseSensitiveCharacter(CharSequence text, int startIndex) {
        for (int i = startIndex; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isLowerCase(c) && !Character.isUpperCase(c)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static Set<String> makeVariations(List<String> originalTexts, char characterToReplace, char ... allowedReplacements) {
        HashSet<String> result = new HashSet<String>();
        for (String originalText : originalTexts) {
            result.add(originalText);
            for (char replacement : allowedReplacements) {
                result.add(originalText.replace(characterToReplace, replacement));
            }
        }
        return result;
    }

    public static void invertSymbolsAndRanges(List<SymbolRange> symbolRanges, CharList symbols, SymbolRange allCharactersRange, List<SymbolRange> invertedRanges, CharList invertedCharacters) {
        int firstCharInRange = allCharactersRange.getFrom();
        int lastCharInRange = allCharactersRange.getTo();
        List<SymbolRange> sortedRanges = Util.getApplicableSortedUniqueRanges(symbolRanges, symbols, allCharactersRange);
        int start = firstCharInRange;
        for (SymbolRange range : sortedRanges) {
            int from = range.getFrom();
            int to = range.getTo();
            if (start <= from) {
                if (start + 1 == from) {
                    invertedCharacters.add(start);
                } else if (start != from) {
                    invertedRanges.add(SymbolRange.range(start, from - 1));
                }
            }
            if ((start = to + 1) <= lastCharInRange) continue;
            return;
        }
        if (start < lastCharInRange) {
            invertedRanges.add(SymbolRange.range(start, lastCharInRange));
        } else if (start == lastCharInRange) {
            invertedCharacters.add(start);
        }
    }

    private static List<SymbolRange> getApplicableSortedUniqueRanges(List<SymbolRange> symbolRanges, CharList symbols, SymbolRange allowedRange) {
        int firstCharInRange = allowedRange.getFrom();
        int lastCharInRange = allowedRange.getTo();
        ArrayList<SymbolRange> list = new ArrayList<SymbolRange>(symbolRanges.size() + symbolRanges.size());
        symbolRanges.stream().filter(range -> range.getTo() >= firstCharInRange && range.getFrom() <= lastCharInRange).forEach(list::add);
        symbols.stream().filter(c -> firstCharInRange <= c.charValue() && c.charValue() <= lastCharInRange).map(symbol -> SymbolRange.range(symbol.charValue(), symbol.charValue())).forEach(list::add);
        list.sort(Comparator.comparing(SymbolRange::getFrom));
        return list;
    }

    public static void compactOverlappingRangesAndSymbols(List<SymbolRange> originalSymbolRanges, CharList originalSymbols, List<SymbolRange> compactedRanges, CharList compactedSymbols) {
        List sortedRanges = Stream.concat(originalSymbolRanges.stream(), originalSymbols.stream().map(symbol -> SymbolRange.range(symbol.charValue(), symbol.charValue()))).sorted(Comparator.comparing(SymbolRange::getFrom)).collect(Collectors.toList());
        if (sortedRanges.size() == 1) {
            compactedSymbols.addAll(originalSymbols);
            compactedRanges.addAll(originalSymbolRanges);
            return;
        }
        int i = 1;
        while (i < sortedRanges.size()) {
            SymbolRange b;
            SymbolRange a = (SymbolRange)sortedRanges.get(i - 1);
            if (Util.isRightWithinLeft(a, b = (SymbolRange)sortedRanges.get(i))) {
                sortedRanges.remove(i);
                continue;
            }
            if (Util.isRightWithinLeft(b, a)) {
                sortedRanges.remove(i - 1);
                continue;
            }
            if (Util.isRightCanContinueLeft(a, b)) {
                sortedRanges.remove(i);
                sortedRanges.set(i - 1, SymbolRange.range(a.getFrom(), b.getTo()));
                continue;
            }
            ++i;
        }
        for (SymbolRange range : sortedRanges) {
            if (range.getFrom() == range.getTo()) {
                compactedSymbols.add((char)range.getFrom());
                continue;
            }
            compactedRanges.add(range);
        }
    }

    public static boolean isRightCanContinueLeft(SymbolRange left, SymbolRange right) {
        return left.getFrom() <= right.getFrom() && right.getFrom() <= left.getTo() + 1 && left.getTo() < right.getTo();
    }

    public static boolean isRightWithinLeft(SymbolRange left, SymbolRange right) {
        return left.getFrom() <= right.getFrom() && left.getTo() >= right.getTo();
    }
}

