/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.datafaker.internal.helper.SingletonLocale;
import net.datafaker.service.FakeValuesService;
import net.datafaker.service.RandomService;

public class FakerContext {
    private static final Pattern LOCALE = Pattern.compile("[-_]");
    private static final Map<SingletonLocale, List<SingletonLocale>> LOCALE_2_LOCALES_CHAIN = new IdentityHashMap<SingletonLocale, List<SingletonLocale>>();
    private static final Map<SingletonLocale, SingletonLocale> STRING_LOCALE_HASH_MAP = new IdentityHashMap<SingletonLocale, SingletonLocale>();
    public static final List<SingletonLocale> DEFAULT_SINGLETON_LOCALE_LIST = List.of(FakeValuesService.DEFAULT_LOCALE);
    private SingletonLocale sLocale;
    private RandomService randomService;

    public FakerContext(Locale locale, RandomService randomService) {
        this.sLocale = SingletonLocale.get(locale);
        this.randomService = randomService;
        this.setCurrentLocale(locale);
    }

    public void setLocale(Locale locale) {
        this.sLocale = SingletonLocale.get(locale);
    }

    public void setRandomService(RandomService randomService) {
        this.randomService = randomService;
    }

    public Locale getLocale() {
        return this.sLocale.getLocale();
    }

    public SingletonLocale getSingletonLocale() {
        return this.sLocale;
    }

    public RandomService getRandomService() {
        return this.randomService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SingletonLocale> getLocaleChain() {
        List<SingletonLocale> res = LOCALE_2_LOCALES_CHAIN.get(this.sLocale);
        if (res == null) {
            Class<FakerContext> clazz = FakerContext.class;
            synchronized (FakerContext.class) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return LOCALE_2_LOCALES_CHAIN.get(this.sLocale);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingletonLocale normalizeLocale(SingletonLocale singletonLocale) {
        SingletonLocale res = STRING_LOCALE_HASH_MAP.get(singletonLocale);
        if (res != null) {
            return res;
        }
        Locale locale = singletonLocale.getLocale();
        String[] parts = locale.getCountry().isEmpty() ? LOCALE.split(locale.getLanguage()) : new String[]{locale.getLanguage(), locale.getCountry()};
        if (parts.length == 1) {
            res = SingletonLocale.get(Locale.forLanguageTag(parts[0]));
            if (res == null) {
                res = SingletonLocale.get(new Locale(parts[0]));
            }
        } else {
            res = SingletonLocale.get(new Locale(parts[0], parts[1]));
        }
        Class<FakerContext> clazz = FakerContext.class;
        synchronized (FakerContext.class) {
            STRING_LOCALE_HASH_MAP.put(singletonLocale, res);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentLocale(Locale locale) {
        Objects.requireNonNull(locale);
        this.sLocale = this.normalizeLocale(SingletonLocale.get(locale));
        if (LOCALE_2_LOCALES_CHAIN.containsKey(this.sLocale)) {
            return;
        }
        Class<FakerContext> clazz = FakerContext.class;
        synchronized (FakerContext.class) {
            LOCALE_2_LOCALES_CHAIN.put(this.sLocale, this.localeChain());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected List<SingletonLocale> localeChain(Locale from) {
        if (FakeValuesService.DEFAULT_LOCALE.getLocale().equals(from)) {
            return DEFAULT_SINGLETON_LOCALE_LIST;
        }
        return this.calculateLocaleChain(this.normalizeLocale(SingletonLocale.get(from)));
    }

    protected List<SingletonLocale> localeChain() {
        if (FakeValuesService.DEFAULT_LOCALE == this.sLocale) {
            return DEFAULT_SINGLETON_LOCALE_LIST;
        }
        return this.calculateLocaleChain(this.sLocale);
    }

    private List<SingletonLocale> calculateLocaleChain(SingletonLocale locale) {
        ArrayList<SingletonLocale> chain = new ArrayList<SingletonLocale>(4);
        chain.add(locale);
        if (!"".equals(locale.getLocale().getCountry())) {
            if (!FakeValuesService.DEFAULT_LOCALE.getLocale().getLanguage().equals(locale.getLocale().getLanguage())) {
                chain.add(SingletonLocale.get(new Locale(locale.getLocale().getLanguage())));
            }
            chain.add(SingletonLocale.get(new Locale("", locale.getLocale().getCountry())));
        }
        chain.add(FakeValuesService.DEFAULT_LOCALE);
        return chain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakerContext that = (FakerContext)o;
        if (!Objects.equals(this.sLocale, that.sLocale)) {
            return false;
        }
        return Objects.equals(this.randomService, that.randomService);
    }

    public int hashCode() {
        int result = this.sLocale != null ? this.sLocale.hashCode() : 0;
        result = 31 * result + (this.randomService != null ? this.randomService.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FakerContext{%s, %s}".formatted(this.sLocale, this.randomService);
    }
}

