/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.datafaker.service.FakeValues;
import net.datafaker.service.FakeValuesContext;
import net.datafaker.service.FakeValuesInterface;
import net.datafaker.service.files.EnFile;

public class FakeValuesGrouping
implements FakeValuesInterface {
    private static final FakeValuesGrouping ENGLISH_FAKE_VALUE_GROUPING = new FakeValuesGrouping();
    private final Map<String, Collection<FakeValuesInterface>> fakeValues = new HashMap<String, Collection<FakeValuesInterface>>();

    public void add(FakeValuesInterface fakeValue) {
        if (fakeValue instanceof FakeValues) {
            ((FakeValues)fakeValue).getPaths().forEach(p -> this.fakeValues.computeIfAbsent((String)p, key -> new HashSet()).add(fakeValue));
        } else if (fakeValue instanceof FakeValuesGrouping) {
            this.fakeValues.putAll(((FakeValuesGrouping)fakeValue).fakeValues);
        } else {
            throw new RuntimeException(this.fakeValues.getClass().getName() + " not supported (please raise an issue)");
        }
    }

    public Map get(String key) {
        Map<String, Object> result = null;
        for (FakeValuesInterface fakeValues : (Collection)this.fakeValues.getOrDefault(key, Collections.emptyList())) {
            if (result == null) {
                result = fakeValues.get(key);
                continue;
            }
            Map<String, Object> newResult = fakeValues.get(key);
            result.putAll(newResult);
        }
        return result;
    }

    public static FakeValuesGrouping getEnglishFakeValueGrouping() {
        return ENGLISH_FAKE_VALUE_GROUPING;
    }

    static {
        EnFile.getFiles().forEach(file -> ENGLISH_FAKE_VALUE_GROUPING.add(FakeValues.of(FakeValuesContext.of(Locale.ENGLISH, file.getFile(), file.getPath()))));
    }
}

