/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.sequence;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.service.RandomService;

public class FakeCollection<T>
extends FakeSequence<T> {
    private static final int FAKE_COLLECTION_DEFAULT_SIZE = 10;

    private FakeCollection(List<Supplier<T>> suppliers, int minLength, int maxLength, RandomService randomService, double nullRate) {
        super(suppliers, minLength, maxLength, randomService, nullRate);
    }

    @Override
    public List<T> get() {
        int size = this.randomService.nextInt(this.minLength, this.maxLength);
        ArrayList result = new ArrayList(size);
        while (result.size() < size) {
            result.add(this.singleton());
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.get().iterator();
    }

    public static class Builder<T>
    extends FakeSequence.Builder<T> {
        public Builder() {
        }

        public Builder(List<Supplier<T>> list) {
            super(list);
        }

        @SafeVarargs
        public Builder(Supplier<T> ... elems) {
            super(elems);
        }

        @Override
        public FakeCollection<T> build() {
            if (this.maxLength < 0) {
                this.maxLen(10);
            }
            if (this.minLength > this.maxLength) {
                throw new IllegalArgumentException("Max length (%s) must be not less than min length (%s) and not negative".formatted(this.maxLength, this.minLength));
            }
            this.minLength = this.minLength < 0 ? this.maxLength : this.minLength;
            RandomService randomService = this.faker == null ? new RandomService() : this.faker.random();
            return new FakeCollection(this.suppliers, this.minLength, this.maxLength, randomService, this.nullRate);
        }
    }
}

