/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.food;

import java.util.Locale;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.food.FoodProviders;

public class Coffee
extends AbstractProvider<FoodProviders> {
    protected Coffee(FoodProviders faker) {
        super(faker);
    }

    public String country() {
        return this.resolve("coffee.country");
    }

    public String region() {
        return this.region(((FoodProviders)this.faker).options().option(Country.class));
    }

    public String region(Country country) {
        return this.resolve("coffee.regions." + country.name().toLowerCase(Locale.ROOT));
    }

    public String variety() {
        return this.resolve("coffee.variety");
    }

    public String intensifier() {
        return this.resolve("coffee.intensifier");
    }

    public String body() {
        return this.resolve("coffee.body");
    }

    public String descriptor() {
        return this.resolve("coffee.descriptor");
    }

    public String notes() {
        return this.resolve("coffee.notes");
    }

    public String name1() {
        return this.resolve("coffee.name_1");
    }

    public String name2() {
        return this.resolve("coffee.name_2");
    }

    public String blendName() {
        return this.resolve("coffee.blend_name");
    }

    public static enum Country {
        BRAZIL,
        COLOMBIA,
        SUMATRA,
        ETHIOPIA,
        HONDURAS,
        KENYA,
        UGANDA,
        MEXICO,
        GUATEMALA,
        NICARAGUA,
        COSTA_RICA,
        TANZANIA,
        EL_SALVADOR,
        RWANDA,
        BURUNDI,
        PANAMA,
        YEMEN,
        INDIA;

    }
}

