/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Logger;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.service.RandomService;

public class Twitter
extends AbstractProvider<BaseProviders> {
    private static final Logger LOGGER = Logger.getLogger(Twitter.class.getName());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.systemDefault());
    private static final String BASIC_STRING = "QabR0cYdZ1efSg2hi3jNOPkTUM4VLlmXK5nJo6WIpHGqF7rEs8tDuC9vwBxAyz";

    protected Twitter(BaseProviders faker) {
        super(faker);
    }

    @Deprecated(since="2.3.0", forRemoval=true)
    public Date createdTime(boolean forward, Date base, Date constraints) {
        RandomService random = ((BaseProviders)this.faker).random();
        long time = base.getTime();
        if (forward) {
            return new Date(time + (long)(random.nextDouble() * (double)(constraints.getTime() - time)));
        }
        return new Date(time - (long)(random.nextDouble() * (double)(time - constraints.getTime())));
    }

    public String twitterId(int expectedLength) {
        int hashCodeV;
        if (expectedLength <= 6 || expectedLength >= 25) {
            LOGGER.warning("expectedLength <= 6 may easily cause twitter id collision. And expectedLength >= 25 can be easily out of bound.");
        }
        if ((hashCodeV = UUID.randomUUID().toString().hashCode()) < 0) {
            hashCodeV = -hashCodeV;
        }
        String id1 = String.valueOf(hashCodeV);
        String newDate = DATE_TIME_FORMATTER.format(Instant.now());
        int capacity = Math.max(0, expectedLength - id1.length() - newDate.length());
        StringBuilder result = new StringBuilder(capacity);
        RandomService random = ((BaseProviders)this.faker).random();
        for (int i = 0; i < capacity; ++i) {
            result.append(random.nextInt(10));
        }
        result.append(newDate);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int j = 0;
        while (i < id1.length() || j < result.length()) {
            if (i < id1.length()) {
                sb.append(id1.charAt(i++));
            }
            if (j >= result.length()) continue;
            sb.append(result.charAt(j++));
        }
        String id = sb.toString();
        int start = random.nextInt(id.length() - expectedLength + 1);
        id = id.substring(start, start + expectedLength);
        return id;
    }

    public String text(String[] keywords, int sentenceMaxLength, int wordMaxLength) {
        if (wordMaxLength <= 2) {
            LOGGER.warning("Word length less than 2 is dangerous. Exceptions can be raised.");
        }
        ArrayList<String> text = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        RandomService random = ((BaseProviders)this.faker).random();
        int sentenceLength = random.nextInt(1, sentenceMaxLength);
        for (int i = 0; i < sentenceLength; ++i) {
            int tmpWordLength = random.nextInt(3, wordMaxLength);
            for (int j = 0; j < tmpWordLength; ++j) {
                sb.append(BASIC_STRING.charAt(random.nextInt(BASIC_STRING.length())));
            }
            text.add(sb.toString());
            sb.setLength(0);
        }
        if (keywords != null) {
            for (String keyword : keywords) {
                int position = random.nextInt(text.size());
                text.add(position, keyword);
            }
        }
        return String.join((CharSequence)" ", text);
    }

    public String userName() {
        return this.resolve("twitter.user_name");
    }

    public String userId() {
        return this.resolve("twitter.user_id");
    }

    public String getLink(String username, int extraLength) {
        if (extraLength <= 4) {
            LOGGER.warning("Extra length <=4 can cause collision.");
        }
        RandomService random = ((BaseProviders)this.faker).random();
        char[] res = new char[extraLength + 1];
        res[0] = 47;
        for (int i = 1; i < res.length; ++i) {
            res[i] = BASIC_STRING.charAt(random.nextInt(BASIC_STRING.length()));
        }
        return "https://twitter.com/" + username + String.valueOf(res);
    }
}

