/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Image
extends AbstractProvider<BaseProviders> {
    private static final int DEFAULT_WIDTH = 256;
    private static final int DEFAULT_HEIGHT = 256;

    protected Image(BaseProviders faker) {
        super(faker);
    }

    public String base64BMP() {
        return this.base64(ImageBuilder.builder().type(ImageType.BMP).build());
    }

    public String base64GIF() {
        return this.base64(ImageBuilder.builder().type(ImageType.GIF).build());
    }

    public String base64JPG() {
        return this.base64JPEG();
    }

    public String base64JPEG() {
        return this.base64(ImageBuilder.builder().type(ImageType.JPEG).build());
    }

    public String base64PNG() {
        return this.base64(ImageBuilder.builder().type(ImageType.PNG).build());
    }

    public String base64SVG() {
        return this.base64(ImageBuilder.builder().type(ImageType.SVG).build());
    }

    public String base64TIFF() {
        return this.generateBase64RasterImage(ImageType.TIFF, 256, 256);
    }

    public String base64(Base64ImageRuleConfig config) {
        if (config.imageType == ImageType.SVG) {
            return this.generateBase64VectorImage(config.imageType(), config.width(), config.height());
        }
        return this.generateBase64RasterImage(config.imageType(), config.width(), config.height());
    }

    private String generateBase64RasterImage(ImageType imageType, int width, int height) {
        String string;
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics = bufferedImage.createGraphics();
        int boxSize = Math.max(1, width / 8);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        for (int y = 0; y < height; y += boxSize) {
            for (int x = 0; x < width; x += boxSize) {
                Color randomColor = this.randomColor();
                graphics.setColor(randomColor);
                graphics.fillRect(x, y, boxSize, boxSize);
            }
        }
        graphics.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, imageType.name(), baos);
            byte[] imageBytes = baos.toByteArray();
            string = "data:" + imageType.mimeType + ";base64," + Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to generate image %s of size %sx%s".formatted(new Object[]{imageType, width, height}), e);
            }
        }
        baos.close();
        return string;
    }

    private String generateBase64VectorImage(ImageType imageType, int width, int height) {
        StringBuilder svg = new StringBuilder();
        svg.append("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"").append(256).append("\" height=\"").append(256).append("\">");
        int boxSize = Math.max(1, width / 8);
        for (int y = 0; y < height; y += boxSize) {
            for (int x = 0; x < width; x += boxSize) {
                Color randomColor = this.randomColor();
                String color = String.format("#%02x%02x%02x", randomColor.getRed(), randomColor.getGreen(), randomColor.getBlue());
                svg.append("<rect x=\"").append(x).append("\" y=\"").append(y).append("\" width=\"").append(boxSize).append("\" height=\"").append(boxSize).append("\" fill=\"").append(color).append("\"/>");
            }
        }
        svg.append("</svg>");
        String svgString = svg.toString();
        String base64Svg = Base64.getEncoder().encodeToString(svgString.getBytes());
        return "data:" + imageType.mimeType + ";base64," + base64Svg;
    }

    private Color randomColor() {
        byte[] randomBytes = ((BaseProviders)this.faker).random().nextRandomBytes(3);
        int red = randomBytes[0] & 0xFF;
        int green = randomBytes[1] & 0xFF;
        int blue = randomBytes[2] & 0xFF;
        return new Color(red, green, blue);
    }

    public static class ImageBuilder {
        private ImageType imageType = ImageType.PNG;
        private int width = 256;
        private int height = 256;

        private ImageBuilder() {
        }

        public static ImageBuilder builder() {
            return new ImageBuilder();
        }

        public Base64ImageRuleConfig build() {
            return new Base64ImageRuleConfig(this.imageType, this.width, this.height);
        }

        public ImageBuilder type(ImageType imageType) {
            if (imageType == null) {
                throw new IllegalArgumentException("Type cannot be null");
            }
            this.imageType = imageType;
            return this;
        }

        public ImageBuilder width(int width) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be greater than 0");
            }
            this.width = width;
            return this;
        }

        public ImageBuilder height(int height) {
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be greater than 0");
            }
            this.height = height;
            return this;
        }
    }

    public static enum ImageType {
        BMP("image/bmp"),
        GIF("image/gif"),
        JPEG("image/jpeg"),
        PNG("image/png"),
        SVG("image/svg+xml"),
        TIFF("image/tiff");

        private final String mimeType;

        private ImageType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }

    public record Base64ImageRuleConfig(ImageType imageType, int width, int height) {
    }
}

