/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

@Deprecated(since="2.3.0", forRemoval=true)
public class DateAndTime
extends AbstractProvider<BaseProviders> {
    private static final int DEFAULT_MIN_AGE = 18;
    private static final int DEFAULT_MAX_AGE = 65;
    public static final long DAYS_NANOS = TimeUnit.DAYS.toNanos(1L);

    protected DateAndTime(BaseProviders faker) {
        super(faker);
    }

    public Timestamp future(int atMost, TimeUnit unit) {
        Timestamp aBitLaterThanNow = new Timestamp(System.currentTimeMillis() + 1L);
        return this.future(atMost, unit, aBitLaterThanNow);
    }

    public String future(int atMost, TimeUnit unit, String pattern) {
        return this.toString(this.future(atMost, unit), pattern);
    }

    public Timestamp future(int atMost, int minimum, TimeUnit unit) {
        Timestamp minimumDate = new Timestamp(System.currentTimeMillis() + unit.toMillis(minimum));
        return this.future(atMost - minimum, unit, minimumDate);
    }

    public String future(int atMost, int minimum, TimeUnit unit, String pattern) {
        return this.toString(this.future(atMost, minimum, unit), pattern);
    }

    public <T extends Date> T future(int atMost, TimeUnit unit, T referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return (T)new Timestamp(futureMillis += 1L + ((BaseProviders)this.faker).random().nextLong(upperBound - 1L));
    }

    public <T extends Date> String future(int atMost, TimeUnit unit, T referenceDate, String pattern) {
        return this.toString(this.future(atMost, unit, referenceDate), pattern);
    }

    public Timestamp past(int atMost, TimeUnit unit) {
        Timestamp aBitEarlierThanNow = new Timestamp(System.currentTimeMillis() - 1L);
        return this.past(atMost, unit, aBitEarlierThanNow);
    }

    public String past(int atMost, TimeUnit unit, String pattern) {
        return this.toString(this.past(atMost, unit), pattern);
    }

    public Timestamp past(int atMost, int minimum, TimeUnit unit) {
        Timestamp minimumDate = new Timestamp(System.currentTimeMillis() - unit.toMillis(minimum));
        return this.past(atMost - minimum, unit, minimumDate);
    }

    public String past(int atMost, int minimum, TimeUnit unit, String pattern) {
        return this.toString(this.past(atMost, minimum, unit), pattern);
    }

    public <T extends Date> T past(int atMost, TimeUnit unit, T referenceDate) {
        long upperBound = unit.toMillis(atMost);
        long futureMillis = referenceDate.getTime();
        return (T)new Timestamp(futureMillis -= 1L + ((BaseProviders)this.faker).random().nextLong(upperBound - 1L));
    }

    public String past(int atMost, TimeUnit unit, Date referenceDate, String pattern) {
        return this.toString(this.past(atMost, unit, referenceDate), pattern);
    }

    public <T extends Date> T between(T from, T to) throws IllegalArgumentException {
        if (to.before(from)) {
            throw new IllegalArgumentException("Invalid date range: the upper bound date (%s) is before the lower bound (%s)".formatted(to, from));
        }
        if (from.equals(to)) {
            return from;
        }
        long offsetMillis = ((BaseProviders)this.faker).random().nextLong(to.getTime() - from.getTime());
        return (T)new Timestamp(from.getTime() + offsetMillis);
    }

    public <T extends Date> String between(T from, T to, String pattern) throws IllegalArgumentException {
        return this.toString(this.between(from, to), pattern);
    }

    public Timestamp birthday() {
        return this.birthday(18, 65);
    }

    public LocalDate birthdayLocalDate() {
        return this.birthdayLocalDate(18, 65);
    }

    public String birthday(String pattern) {
        return this.toString(this.birthday(18, 65), pattern);
    }

    public Timestamp birthday(int minAge, int maxAge) {
        LocalDate localDate = LocalDate.now();
        LocalDate from = localDate.minusYears(maxAge);
        if (minAge == maxAge) {
            return Timestamp.valueOf(LocalDateTime.of(from, LocalTime.MIDNIGHT));
        }
        long start = from.toEpochDay();
        long stop = localDate.minusYears(minAge).toEpochDay();
        LocalDate date = LocalDate.ofEpochDay(((BaseProviders)this.faker).random().nextLong(start, stop));
        return Timestamp.valueOf(LocalDateTime.of(date, LocalTime.ofNanoOfDay(((BaseProviders)this.faker).number().numberBetween(0L, DAYS_NANOS))));
    }

    public LocalDate birthdayLocalDate(int minAge, int maxAge) {
        LocalDate localDate = LocalDate.now();
        LocalDate from = localDate.minusYears(maxAge);
        if (minAge == maxAge) {
            return from;
        }
        long start = from.toEpochDay();
        long stop = localDate.minusYears(minAge).toEpochDay();
        return LocalDate.ofEpochDay(((BaseProviders)this.faker).random().nextLong(start, stop));
    }

    public String birthday(int minAge, int maxAge, String pattern) {
        return this.toString(this.birthday(minAge, maxAge), pattern);
    }

    public Duration duration(long max, ChronoUnit unit) {
        return this.duration(0L, max, unit);
    }

    public Duration duration(long min, long max, ChronoUnit unit) {
        return this.generateDuration(((BaseProviders)this.faker).random().nextLong(min, max), unit);
    }

    public Duration duration(long max, String unit) {
        return this.duration(0L, max, DateAndTime.str2durationUnit(unit));
    }

    public Duration duration(long min, long max, String unit) {
        return this.generateDuration(((BaseProviders)this.faker).random().nextLong(min, max), DateAndTime.str2durationUnit(unit));
    }

    public Period period(Period min, Period max) {
        if (max.minus(min).isNegative()) {
            throw new IllegalArgumentException("Max period(" + max + ") should be not less than min (" + min + ")");
        }
        return Period.of(((BaseProviders)this.faker).random().nextInt(min.getYears(), max.getYears()), ((BaseProviders)this.faker).random().nextInt(min.getMonths(), max.getMonths()), ((BaseProviders)this.faker).random().nextInt(min.getDays(), max.getDays()));
    }

    static ChronoUnit str2durationUnit(String unit) {
        if (unit == null || unit.trim().isEmpty()) {
            throw new IllegalArgumentException("Illegal duration unit '" + unit + "'");
        }
        return switch (unit.toUpperCase(Locale.ROOT)) {
            case "NANO", "NANOS" -> ChronoUnit.NANOS;
            case "MICRO", "MICROS" -> ChronoUnit.MICROS;
            case "MILLI", "MILLIS" -> ChronoUnit.MILLIS;
            case "SECOND", "SECONDS" -> ChronoUnit.SECONDS;
            case "MINUTE", "MINUTES" -> ChronoUnit.MINUTES;
            case "HOUR", "HOURS" -> ChronoUnit.HOURS;
            case "DAY", "DAYS" -> ChronoUnit.DAYS;
            default -> throw new IllegalArgumentException("Illegal duration unit '" + unit + "'");
        };
    }

    private Duration generateDuration(long value, ChronoUnit unit) {
        return Duration.of(value, unit);
    }

    private String toString(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }
}

