/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;

public class Compass
extends AbstractProvider<BaseProviders> {
    private CompassPoint compassPoint;

    protected Compass(BaseProviders faker) {
        super(faker);
    }

    public Compass compassPoint(CompassPoint compassPoint) {
        this.compassPoint = compassPoint;
        return this;
    }

    public String word() {
        if (this.compassPoint == null) {
            return this.resolve("compass.direction");
        }
        return this.resolve("compass." + this.compassPoint.yamlKey + ".word");
    }

    public String abbreviation() {
        if (this.compassPoint == null) {
            return this.resolve("compass.abbreviation");
        }
        return this.resolve("compass." + this.compassPoint.yamlKey + ".abbreviation");
    }

    public String azimuth() {
        if (this.compassPoint == null) {
            return this.resolve("compass.azimuth");
        }
        return this.resolve("compass." + this.compassPoint.yamlKey + ".azimuth");
    }

    public static enum CompassPoint {
        CARDINAL("cardinal"),
        ORDINAL("ordinal"),
        HALF_WIND("half-wind"),
        QUARTER_WIND("quarter-wind");

        private final String yamlKey;

        private CompassPoint(String yamlKey) {
            this.yamlKey = yamlKey;
        }
    }
}

