/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class Utils {
    static LocalDate birthday(BaseProviders faker, IdNumber.IdNumberRequest request) {
        return faker.timeAndDate().birthday(request.minAge(), request.maxAge());
    }

    static PersonIdNumber.Gender gender(BaseProviders faker, IdNumber.IdNumberRequest request) {
        IdNumber.GenderRequest gender = request.gender();
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case IdNumber.GenderRequest.FEMALE -> PersonIdNumber.Gender.FEMALE;
            case IdNumber.GenderRequest.MALE -> PersonIdNumber.Gender.MALE;
            case IdNumber.GenderRequest.ANY -> Utils.randomGender(faker);
        };
    }

    static PersonIdNumber.Gender randomGender(BaseProviders faker) {
        return faker.bool().bool() ? PersonIdNumber.Gender.FEMALE : PersonIdNumber.Gender.MALE;
    }

    static int digitAt(String text, int index) {
        return Utils.digit(text.charAt(index));
    }

    static int digit(char c) {
        return c - 48;
    }

    static int multiply(String text, int[] weights) {
        int checksum = 0;
        for (int i = 0; i < text.length(); ++i) {
            checksum += Utils.digitAt(text, i) * weights[i];
        }
        return checksum;
    }
}

