/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class SwedenIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    private static final String[] VALID_PATTERNS = new String[]{"######-####", "######+####"};
    private static final String[] PLUS_MINUS = new String[]{"+", "-"};

    @Override
    public String countryCode() {
        return "SE";
    }

    @Deprecated
    public String getValidSsn(BaseProviders f) {
        return this.generateValid(f);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders f, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(f, request);
        String end = SwedenIdNumber.generateEndPart(f);
        String basePart = DATE_TIME_FORMATTER.format(birthday) + f.options().option(PLUS_MINUS) + end;
        String idNumber = basePart + SwedenIdNumber.calculateChecksum(basePart);
        return new PersonIdNumber(idNumber, birthday, Utils.gender(f, request));
    }

    public static String generateEndPart(BaseProviders f) {
        return "%03d".formatted(f.number().numberBetween(1, 1000));
    }

    @Deprecated
    public String getInvalidSsn(BaseProviders f) {
        return this.generateInvalid(f);
    }

    @Override
    public String generateInvalid(BaseProviders f) {
        String candidate = "121212-1212";
        while (SwedenIdNumber.isValidSwedishSsn(candidate)) {
            String pattern = this.getPattern(f);
            candidate = f.numerify(pattern);
        }
        return candidate;
    }

    private String getPattern(BaseProviders faker) {
        return faker.options().option(VALID_PATTERNS);
    }

    public static boolean isValidSwedishSsn(String ssn) {
        if (ssn.length() != 11) {
            return false;
        }
        try {
            if (SwedenIdNumber.parseDate(ssn)) {
                return false;
            }
        }
        catch (NumberFormatException | DateTimeParseException ignore) {
            return false;
        }
        if (ssn.startsWith("000", 7)) {
            return false;
        }
        int calculatedChecksum = SwedenIdNumber.calculateChecksum(ssn);
        int checksum = Integer.parseInt(ssn.substring(10, 11));
        return checksum == calculatedChecksum;
    }

    private static boolean parseDate(String ssn) {
        String dateString = ssn.substring(0, 6);
        if (ChronoField.YEAR.range().isValidIntValue(Integer.parseInt(dateString.substring(0, 2))) && ChronoField.MONTH_OF_YEAR.range().isValidIntValue(Integer.parseInt(dateString.substring(2, 4))) && ChronoField.DAY_OF_MONTH.range().isValidIntValue(Integer.parseInt(dateString.substring(4)))) {
            LocalDate date = LocalDate.parse(dateString, DATE_TIME_FORMATTER);
            String reversed = date.format(DATE_TIME_FORMATTER);
            return !reversed.equals(dateString);
        }
        return true;
    }

    private static int calculateChecksum(String number) {
        String dateString = number.substring(0, 6);
        String birthNumber = number.substring(7, 10);
        String calculatedNumber = SwedenIdNumber.calculateDigits(dateString + birthNumber);
        int sum = SwedenIdNumber.calculateDigitSum(calculatedNumber);
        int lastDigit = sum % 10;
        int difference = 10 - lastDigit;
        return difference % 10;
    }

    private static String calculateDigits(String numbers) {
        StringBuilder calculatedNumbers = new StringBuilder();
        for (int i = 0; i < 9; ++i) {
            int n = numbers.charAt(i) - 48;
            int res = i % 2 == 0 ? n << 1 : n;
            calculatedNumbers.append(res);
        }
        return calculatedNumbers.toString();
    }

    private static int calculateDigitSum(String numbers) {
        int sum = 0;
        int length = numbers.length();
        for (int i = 0; i < length; ++i) {
            int n = numbers.charAt(i) - 48;
            sum += n;
        }
        return sum;
    }
}

