/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class RomanianIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd");
    private static final int[] CHECKSUM_WEIGHTS = new int[]{2, 7, 9, 1, 4, 6, 3, 5, 8, 2, 7, 9};

    @Override
    public String countryCode() {
        return "RO";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String basePart = this.basePart(faker, birthday, gender);
        String idNumber = basePart + this.checksum(basePart);
        return new PersonIdNumber(idNumber, birthday, gender);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        LocalDate birthday = faker.timeAndDate().birthday();
        PersonIdNumber.Gender gender = Utils.randomGender(faker);
        String basePart = this.basePart(faker, birthday, gender);
        return basePart + (this.checksum(basePart) + 1) % 10;
    }

    private String basePart(BaseProviders faker, LocalDate birthday, PersonIdNumber.Gender gender) {
        return this.firstCharacter(birthday, gender) + this.dateOfBirth(birthday) + this.countyCode(faker) + this.sequenceNumber(faker);
    }

    int firstCharacter(LocalDate birthday, PersonIdNumber.Gender gender) {
        int digit = switch (birthday.getYear() / 100) {
            case 18 -> 3;
            case 19 -> 1;
            case 20 -> 5;
            default -> throw new IllegalArgumentException("Too far in the past or future: " + birthday);
        };
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> digit + 1;
            case PersonIdNumber.Gender.MALE -> digit;
        };
    }

    String dateOfBirth(LocalDate birthday) {
        return DATE_TIME_FORMATTER.format(birthday);
    }

    String countyCode(BaseProviders faker) {
        int countyCode = faker.bool().bool() ? faker.number().numberBetween(1, 47) : faker.number().numberBetween(51, 53);
        return "%02d".formatted(countyCode);
    }

    String sequenceNumber(BaseProviders faker) {
        return "%03d".formatted(faker.number().numberBetween(1, 1000));
    }

    int checksum(String basePart) {
        int result = Utils.multiply(basePart, CHECKSUM_WEIGHTS) % 11;
        return result == 10 ? 1 : result;
    }
}

