/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class AlbanianIdNumber
implements IdNumberGenerator {
    private static final String FIRST_CHAR = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String CHECKSUM_CHAR = "WABCDEFGHIJKLMNOPQRSTUV";

    @Override
    public String countryCode() {
        return "AL";
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String pin = this.generateValid(faker);
        int invalidMonth = faker.number().numberBetween(93, 99);
        return pin.substring(0, 2) + invalidMonth + pin.substring(4);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthDate = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String basePart = this.yy(birthDate.getYear()) + this.mm(birthDate.getMonthValue(), gender) + this.dd(birthDate.getDayOfMonth()) + this.sss(faker);
        String idNumber = basePart + this.checksum(basePart);
        return new PersonIdNumber(idNumber, birthDate, gender);
    }

    String yy(int year) {
        return FIRST_CHAR.charAt((year - 1800) / 10) + String.valueOf(year % 10);
    }

    String mm(int month, PersonIdNumber.Gender gender) {
        return String.format("%02d", (gender == PersonIdNumber.Gender.FEMALE ? 50 : 0) + month);
    }

    String dd(int dayOfMonth) {
        return String.format("%02d", dayOfMonth);
    }

    private String sss(BaseProviders faker) {
        return faker.number().digits(3);
    }

    char checksum(String text) {
        int checksum = this.checksumOfFirstChar(text.charAt(0));
        for (int i = 1; i < text.length(); ++i) {
            checksum += Utils.digitAt(text, i) * i;
        }
        return CHECKSUM_CHAR.charAt(checksum % 23);
    }

    int checksumOfFirstChar(char c) {
        return Character.isLetter(c) ? CHECKSUM_CHAR.indexOf(c) : Utils.digit(c);
    }
}

